/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.expression.visitor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.mpp.common.NodeRef;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.mpp.plan.expression.binary.BinaryExpression;
import org.apache.iotdb.db.mpp.plan.expression.leaf.ConstantOperand;
import org.apache.iotdb.db.mpp.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.mpp.plan.expression.leaf.TimestampOperand;
import org.apache.iotdb.db.mpp.plan.expression.multi.FunctionExpression;
import org.apache.iotdb.db.mpp.plan.expression.ternary.BetweenExpression;
import org.apache.iotdb.db.mpp.plan.expression.ternary.TernaryExpression;
import org.apache.iotdb.db.mpp.plan.expression.unary.InExpression;
import org.apache.iotdb.db.mpp.plan.expression.unary.IsNullExpression;
import org.apache.iotdb.db.mpp.plan.expression.unary.LikeExpression;
import org.apache.iotdb.db.mpp.plan.expression.unary.RegularExpression;
import org.apache.iotdb.db.mpp.plan.expression.unary.UnaryExpression;
import org.apache.iotdb.db.mpp.plan.expression.visitor.ExpressionVisitor;
import org.apache.iotdb.db.mpp.transformation.api.LayerPointReader;
import org.apache.iotdb.db.mpp.transformation.dag.input.QueryDataSetInputLayer;
import org.apache.iotdb.db.mpp.transformation.dag.intermediate.ConstantIntermediateLayer;
import org.apache.iotdb.db.mpp.transformation.dag.intermediate.IntermediateLayer;
import org.apache.iotdb.db.mpp.transformation.dag.intermediate.MultiInputColumnIntermediateLayer;
import org.apache.iotdb.db.mpp.transformation.dag.intermediate.SingleInputColumnMultiReferenceIntermediateLayer;
import org.apache.iotdb.db.mpp.transformation.dag.intermediate.SingleInputColumnSingleReferenceIntermediateLayer;
import org.apache.iotdb.db.mpp.transformation.dag.memory.LayerMemoryAssigner;
import org.apache.iotdb.db.mpp.transformation.dag.transformer.Transformer;
import org.apache.iotdb.db.mpp.transformation.dag.transformer.binary.ArithmeticAdditionTransformer;
import org.apache.iotdb.db.mpp.transformation.dag.transformer.binary.ArithmeticDivisionTransformer;
import org.apache.iotdb.db.mpp.transformation.dag.transformer.binary.ArithmeticModuloTransformer;
import org.apache.iotdb.db.mpp.transformation.dag.transformer.binary.ArithmeticMultiplicationTransformer;
import org.apache.iotdb.db.mpp.transformation.dag.transformer.binary.ArithmeticSubtractionTransformer;
import org.apache.iotdb.db.mpp.transformation.dag.transformer.binary.CompareEqualToTransformer;
import org.apache.iotdb.db.mpp.transformation.dag.transformer.binary.CompareGreaterEqualTransformer;
import org.apache.iotdb.db.mpp.transformation.dag.transformer.binary.CompareGreaterThanTransformer;
import org.apache.iotdb.db.mpp.transformation.dag.transformer.binary.CompareLessEqualTransformer;
import org.apache.iotdb.db.mpp.transformation.dag.transformer.binary.CompareLessThanTransformer;
import org.apache.iotdb.db.mpp.transformation.dag.transformer.binary.CompareNonEqualTransformer;
import org.apache.iotdb.db.mpp.transformation.dag.transformer.binary.LogicAndTransformer;
import org.apache.iotdb.db.mpp.transformation.dag.transformer.binary.LogicOrTransformer;
import org.apache.iotdb.db.mpp.transformation.dag.transformer.multi.MappableUDFQueryRowTransformer;
import org.apache.iotdb.db.mpp.transformation.dag.transformer.multi.UDFQueryRowTransformer;
import org.apache.iotdb.db.mpp.transformation.dag.transformer.multi.UDFQueryRowWindowTransformer;
import org.apache.iotdb.db.mpp.transformation.dag.transformer.multi.UDFQueryTransformer;
import org.apache.iotdb.db.mpp.transformation.dag.transformer.ternary.BetweenTransformer;
import org.apache.iotdb.db.mpp.transformation.dag.transformer.unary.ArithmeticNegationTransformer;
import org.apache.iotdb.db.mpp.transformation.dag.transformer.unary.DiffFunctionTransformer;
import org.apache.iotdb.db.mpp.transformation.dag.transformer.unary.InTransformer;
import org.apache.iotdb.db.mpp.transformation.dag.transformer.unary.IsNullTransformer;
import org.apache.iotdb.db.mpp.transformation.dag.transformer.unary.LogicNotTransformer;
import org.apache.iotdb.db.mpp.transformation.dag.transformer.unary.RegularTransformer;
import org.apache.iotdb.db.mpp.transformation.dag.transformer.unary.TransparentTransformer;
import org.apache.iotdb.db.mpp.transformation.dag.udf.UDTFContext;
import org.apache.iotdb.db.mpp.transformation.dag.udf.UDTFExecutor;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.udf.api.customizer.strategy.AccessStrategy;

public class IntermediateLayerVisitor
extends ExpressionVisitor<IntermediateLayer, IntermediateLayerVisitorContext> {
    @Override
    public IntermediateLayer visitExpression(Expression expression, IntermediateLayerVisitorContext context) {
        throw new UnsupportedOperationException("Unsupported statement type: " + expression.getClass().getName());
    }

    @Override
    public IntermediateLayer visitUnaryExpression(UnaryExpression unaryExpression, IntermediateLayerVisitorContext context) {
        if (!context.expressionIntermediateLayerMap.containsKey(unaryExpression)) {
            float memoryBudgetInMB = context.memoryAssigner.assign();
            IntermediateLayer parentLayerPointReader = (IntermediateLayer)this.process(unaryExpression.getExpression(), context);
            Transformer transformer = this.getConcreteUnaryTransformer(unaryExpression, parentLayerPointReader.constructPointReader());
            context.expressionIntermediateLayerMap.put(unaryExpression, context.memoryAssigner.getReference(unaryExpression) == 1 || unaryExpression.isConstantOperand() ? new SingleInputColumnSingleReferenceIntermediateLayer(unaryExpression, context.queryId, memoryBudgetInMB, transformer) : new SingleInputColumnMultiReferenceIntermediateLayer(unaryExpression, context.queryId, memoryBudgetInMB, transformer));
        }
        return context.expressionIntermediateLayerMap.get(unaryExpression);
    }

    @Override
    public IntermediateLayer visitBinaryExpression(BinaryExpression binaryExpression, IntermediateLayerVisitorContext context) {
        if (!context.expressionIntermediateLayerMap.containsKey(binaryExpression)) {
            float memoryBudgetInMB = context.memoryAssigner.assign();
            IntermediateLayer leftParentIntermediateLayer = (IntermediateLayer)this.process(binaryExpression.getLeftExpression(), context);
            IntermediateLayer rightParentIntermediateLayer = (IntermediateLayer)this.process(binaryExpression.getRightExpression(), context);
            Transformer transformer = this.getConcreteBinaryTransformer(binaryExpression, leftParentIntermediateLayer.constructPointReader(), rightParentIntermediateLayer.constructPointReader());
            context.expressionIntermediateLayerMap.put(binaryExpression, context.memoryAssigner.getReference(binaryExpression) == 1 || binaryExpression.isConstantOperand() ? new SingleInputColumnSingleReferenceIntermediateLayer(binaryExpression, context.queryId, memoryBudgetInMB, transformer) : new SingleInputColumnMultiReferenceIntermediateLayer(binaryExpression, context.queryId, memoryBudgetInMB, transformer));
        }
        return context.expressionIntermediateLayerMap.get(binaryExpression);
    }

    @Override
    public IntermediateLayer visitTernaryExpression(TernaryExpression ternaryExpression, IntermediateLayerVisitorContext context) {
        if (!context.expressionIntermediateLayerMap.containsKey(ternaryExpression)) {
            float memoryBudgetInMB = context.memoryAssigner.assign();
            IntermediateLayer firstParentIntermediateLayer = (IntermediateLayer)this.process(ternaryExpression.getFirstExpression(), context);
            IntermediateLayer secondParentIntermediateLayer = (IntermediateLayer)this.process(ternaryExpression.getSecondExpression(), context);
            IntermediateLayer thirdParentIntermediateLayer = (IntermediateLayer)this.process(ternaryExpression.getThirdExpression(), context);
            Transformer transformer = this.getConcreteTernaryTransformer(ternaryExpression, firstParentIntermediateLayer.constructPointReader(), secondParentIntermediateLayer.constructPointReader(), thirdParentIntermediateLayer.constructPointReader());
            context.expressionIntermediateLayerMap.put(ternaryExpression, context.memoryAssigner.getReference(ternaryExpression) == 1 || ternaryExpression.isConstantOperand() ? new SingleInputColumnSingleReferenceIntermediateLayer(ternaryExpression, context.queryId, memoryBudgetInMB, transformer) : new SingleInputColumnMultiReferenceIntermediateLayer(ternaryExpression, context.queryId, memoryBudgetInMB, transformer));
        }
        return context.expressionIntermediateLayerMap.get(ternaryExpression);
    }

    @Override
    public IntermediateLayer visitFunctionExpression(FunctionExpression functionExpression, IntermediateLayerVisitorContext context) {
        if (!context.expressionIntermediateLayerMap.containsKey(functionExpression)) {
            Transformer transformer;
            float memoryBudgetInMB = context.memoryAssigner.assign();
            if (functionExpression.isBuiltInAggregationFunctionExpression()) {
                transformer = new TransparentTransformer(context.rawTimeSeriesInputLayer.constructValuePointReader(functionExpression.getInputColumnIndex()));
            } else if (functionExpression.isBuiltInFunction().booleanValue()) {
                transformer = this.getBuiltInFunctionTransformer(functionExpression, context);
            } else {
                try {
                    IntermediateLayer udfInputIntermediateLayer = this.constructUdfInputIntermediateLayer(functionExpression, context);
                    transformer = this.getUdfTransformer(functionExpression, context, udfInputIntermediateLayer);
                }
                catch (IOException | QueryProcessException e) {
                    throw new RuntimeException((Throwable)e);
                }
            }
            context.expressionIntermediateLayerMap.put(functionExpression, context.memoryAssigner.getReference(functionExpression) == 1 ? new SingleInputColumnSingleReferenceIntermediateLayer(functionExpression, context.queryId, memoryBudgetInMB, transformer) : new SingleInputColumnMultiReferenceIntermediateLayer(functionExpression, context.queryId, memoryBudgetInMB, transformer));
        }
        return context.expressionIntermediateLayerMap.get(functionExpression);
    }

    private Transformer getBuiltInFunctionTransformer(FunctionExpression expression, IntermediateLayerVisitorContext context) {
        LayerPointReader childPointReader = ((IntermediateLayer)this.process(expression.getExpressions().get(0), context)).constructPointReader();
        switch (expression.getFunctionName()) {
            case "diff": {
                return new DiffFunctionTransformer(childPointReader, Boolean.parseBoolean(expression.getFunctionAttributes().getOrDefault("ignoreNull", "true")));
            }
        }
        throw new IllegalArgumentException("Invalid Scalar function: " + expression.getExpressionString());
    }

    @Override
    public IntermediateLayer visitTimeStampOperand(TimestampOperand timestampOperand, IntermediateLayerVisitorContext context) {
        if (!context.expressionIntermediateLayerMap.containsKey(timestampOperand)) {
            float memoryBudgetInMB = context.memoryAssigner.assign();
            LayerPointReader parentLayerPointReader = context.rawTimeSeriesInputLayer.constructTimePointReader();
            context.expressionIntermediateLayerMap.put(timestampOperand, context.memoryAssigner.getReference(timestampOperand) == 1 ? new SingleInputColumnSingleReferenceIntermediateLayer(timestampOperand, context.queryId, memoryBudgetInMB, parentLayerPointReader) : new SingleInputColumnMultiReferenceIntermediateLayer(timestampOperand, context.queryId, memoryBudgetInMB, parentLayerPointReader));
        }
        return context.expressionIntermediateLayerMap.get(timestampOperand);
    }

    @Override
    public IntermediateLayer visitTimeSeriesOperand(TimeSeriesOperand timeSeriesOperand, IntermediateLayerVisitorContext context) {
        if (!context.expressionIntermediateLayerMap.containsKey(timeSeriesOperand)) {
            float memoryBudgetInMB = context.memoryAssigner.assign();
            LayerPointReader parentLayerPointReader = context.rawTimeSeriesInputLayer.constructValuePointReader(timeSeriesOperand.getInputColumnIndex());
            context.expressionIntermediateLayerMap.put(timeSeriesOperand, context.memoryAssigner.getReference(timeSeriesOperand) == 1 ? new SingleInputColumnSingleReferenceIntermediateLayer(timeSeriesOperand, context.queryId, memoryBudgetInMB, parentLayerPointReader) : new SingleInputColumnMultiReferenceIntermediateLayer(timeSeriesOperand, context.queryId, memoryBudgetInMB, parentLayerPointReader));
        }
        return context.expressionIntermediateLayerMap.get(timeSeriesOperand);
    }

    @Override
    public IntermediateLayer visitConstantOperand(ConstantOperand constantOperand, IntermediateLayerVisitorContext context) {
        if (!context.expressionIntermediateLayerMap.containsKey(constantOperand)) {
            try {
                ConstantIntermediateLayer intermediateLayer = new ConstantIntermediateLayer(constantOperand, context.queryId, context.memoryAssigner.assign());
                context.expressionIntermediateLayerMap.put(constantOperand, intermediateLayer);
            }
            catch (QueryProcessException e) {
                throw new RuntimeException((Throwable)((Object)e));
            }
        }
        return context.expressionIntermediateLayerMap.get(constantOperand);
    }

    private Transformer getConcreteUnaryTransformer(Expression expression, LayerPointReader pointReader) {
        switch (expression.getExpressionType()) {
            case IN: {
                InExpression inExpression = (InExpression)expression;
                return new InTransformer(pointReader, inExpression.isNotIn(), inExpression.getValues());
            }
            case IS_NULL: {
                IsNullExpression isNullExpression = (IsNullExpression)expression;
                return new IsNullTransformer(pointReader, isNullExpression.isNot());
            }
            case LOGIC_NOT: {
                return new LogicNotTransformer(pointReader);
            }
            case NEGATION: {
                return new ArithmeticNegationTransformer(pointReader);
            }
            case LIKE: {
                LikeExpression likeExpression = (LikeExpression)expression;
                return new RegularTransformer(pointReader, likeExpression.getPattern());
            }
            case REGEXP: {
                RegularExpression regularExpression = (RegularExpression)expression;
                return new RegularTransformer(pointReader, regularExpression.getPattern());
            }
        }
        throw new UnsupportedOperationException("Unsupported Expression Type: " + (Object)((Object)expression.getExpressionType()));
    }

    private Transformer getConcreteBinaryTransformer(Expression expression, LayerPointReader leftParentLayerPointReader, LayerPointReader rightParentLayerPointReader) {
        switch (expression.getExpressionType()) {
            case ADDITION: {
                return new ArithmeticAdditionTransformer(leftParentLayerPointReader, rightParentLayerPointReader);
            }
            case SUBTRACTION: {
                return new ArithmeticSubtractionTransformer(leftParentLayerPointReader, rightParentLayerPointReader);
            }
            case MULTIPLICATION: {
                return new ArithmeticMultiplicationTransformer(leftParentLayerPointReader, rightParentLayerPointReader);
            }
            case DIVISION: {
                return new ArithmeticDivisionTransformer(leftParentLayerPointReader, rightParentLayerPointReader);
            }
            case MODULO: {
                return new ArithmeticModuloTransformer(leftParentLayerPointReader, rightParentLayerPointReader);
            }
            case EQUAL_TO: {
                return new CompareEqualToTransformer(leftParentLayerPointReader, rightParentLayerPointReader);
            }
            case NON_EQUAL: {
                return new CompareNonEqualTransformer(leftParentLayerPointReader, rightParentLayerPointReader);
            }
            case GREATER_THAN: {
                return new CompareGreaterThanTransformer(leftParentLayerPointReader, rightParentLayerPointReader);
            }
            case GREATER_EQUAL: {
                return new CompareGreaterEqualTransformer(leftParentLayerPointReader, rightParentLayerPointReader);
            }
            case LESS_THAN: {
                return new CompareLessThanTransformer(leftParentLayerPointReader, rightParentLayerPointReader);
            }
            case LESS_EQUAL: {
                return new CompareLessEqualTransformer(leftParentLayerPointReader, rightParentLayerPointReader);
            }
            case LOGIC_AND: {
                return new LogicAndTransformer(leftParentLayerPointReader, rightParentLayerPointReader);
            }
            case LOGIC_OR: {
                return new LogicOrTransformer(leftParentLayerPointReader, rightParentLayerPointReader);
            }
        }
        throw new UnsupportedOperationException("Unsupported Expression Type: " + (Object)((Object)expression.getExpressionType()));
    }

    private Transformer getConcreteTernaryTransformer(Expression expression, LayerPointReader firstParentLayerPointReader, LayerPointReader secondParentLayerPointReader, LayerPointReader thirdParentLayerPointReader) {
        switch (expression.getExpressionType()) {
            case BETWEEN: {
                BetweenExpression betweenExpression = (BetweenExpression)expression;
                return new BetweenTransformer(firstParentLayerPointReader, secondParentLayerPointReader, thirdParentLayerPointReader, betweenExpression.isNotBetween());
            }
        }
        throw new UnsupportedOperationException("Unsupported Expression Type: " + (Object)((Object)expression.getExpressionType()));
    }

    private UDFQueryTransformer getUdfTransformer(FunctionExpression functionExpression, IntermediateLayerVisitorContext context, IntermediateLayer udfInputIntermediateLayer) throws QueryProcessException, IOException {
        UDTFExecutor executor = context.udtfContext.getExecutorByFunctionExpression(functionExpression);
        List<Expression> expressions = functionExpression.getExpressions();
        executor.beforeStart(context.queryId, context.memoryAssigner.assign(), expressions.stream().map(Expression::toString).collect(Collectors.toList()), expressions.stream().map(context::getType).collect(Collectors.toList()), functionExpression.getFunctionAttributes());
        AccessStrategy accessStrategy = executor.getConfigurations().getAccessStrategy();
        switch (accessStrategy.getAccessStrategyType()) {
            case MAPPABLE_ROW_BY_ROW: {
                return new MappableUDFQueryRowTransformer(udfInputIntermediateLayer.constructRowReader(), executor);
            }
            case ROW_BY_ROW: {
                return new UDFQueryRowTransformer(udfInputIntermediateLayer.constructRowReader(), executor);
            }
            case SLIDING_SIZE_WINDOW: 
            case SLIDING_TIME_WINDOW: 
            case SESSION_TIME_WINDOW: 
            case STATE_WINDOW: {
                return new UDFQueryRowWindowTransformer(udfInputIntermediateLayer.constructRowWindowReader(accessStrategy, context.memoryAssigner.assign()), executor);
            }
        }
        throw new UnsupportedOperationException("Unsupported transformer access strategy");
    }

    private IntermediateLayer constructUdfInputIntermediateLayer(FunctionExpression functionExpression, IntermediateLayerVisitorContext context) throws QueryProcessException, IOException {
        ArrayList<IntermediateLayer> intermediateLayers = new ArrayList<IntermediateLayer>();
        for (Expression expression : functionExpression.getExpressions()) {
            intermediateLayers.add((IntermediateLayer)this.process(expression, context));
        }
        return intermediateLayers.size() == 1 ? (IntermediateLayer)intermediateLayers.get(0) : new MultiInputColumnIntermediateLayer(functionExpression, context.queryId, context.memoryAssigner.assign(), intermediateLayers.stream().map(IntermediateLayer::constructPointReader).collect(Collectors.toList()));
    }

    public static class IntermediateLayerVisitorContext {
        String queryId;
        UDTFContext udtfContext;
        QueryDataSetInputLayer rawTimeSeriesInputLayer;
        Map<Expression, IntermediateLayer> expressionIntermediateLayerMap;
        Map<NodeRef<Expression>, TSDataType> expressionTypes;
        LayerMemoryAssigner memoryAssigner;

        public IntermediateLayerVisitorContext(String queryId, UDTFContext udtfContext, QueryDataSetInputLayer rawTimeSeriesInputLayer, Map<Expression, IntermediateLayer> expressionIntermediateLayerMap, Map<NodeRef<Expression>, TSDataType> expressionTypes, LayerMemoryAssigner memoryAssigner) {
            this.queryId = queryId;
            this.udtfContext = udtfContext;
            this.rawTimeSeriesInputLayer = rawTimeSeriesInputLayer;
            this.expressionIntermediateLayerMap = expressionIntermediateLayerMap;
            this.expressionTypes = expressionTypes;
            this.memoryAssigner = memoryAssigner;
        }

        public TSDataType getType(Expression expression) {
            return this.expressionTypes.get(NodeRef.of(expression));
        }
    }
}

