/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.metric;

import java.util.Objects;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.db.engine.cache.TimeSeriesMetadataCache;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;

public class TimeSeriesMetadataCacheMetrics
implements IMetricSet {
    private final TimeSeriesMetadataCache timeSeriesMetadataCache;

    public TimeSeriesMetadataCacheMetrics(TimeSeriesMetadataCache timeSeriesMetadataCache) {
        this.timeSeriesMetadataCache = timeSeriesMetadataCache;
    }

    public void bindTo(AbstractMetricService metricService) {
        metricService.createAutoGauge(Metric.CACHE_HIT.toString(), MetricLevel.IMPORTANT, (Object)this.timeSeriesMetadataCache, l -> this.timeSeriesMetadataCache.calculateTimeSeriesMetadataHitRatio() * 100.0, new String[]{Tag.NAME.toString(), "timeSeriesMeta"});
        metricService.createAutoGauge(Metric.CACHE_HIT.toString(), MetricLevel.IMPORTANT, (Object)this.timeSeriesMetadataCache, l -> this.timeSeriesMetadataCache.calculateBloomFilterHitRatio() * 100.0, new String[]{Tag.NAME.toString(), "bloomFilter"});
    }

    public void unbindFrom(AbstractMetricService metricService) {
        metricService.remove(MetricType.AUTO_GAUGE, Metric.CACHE_HIT.toString(), new String[]{Tag.NAME.toString(), "timeSeriesMeta"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.CACHE_HIT.toString(), new String[]{Tag.NAME.toString(), "bloomFilter"});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeSeriesMetadataCacheMetrics that = (TimeSeriesMetadataCacheMetrics)o;
        return Objects.equals(this.timeSeriesMetadataCache, that.timeSeriesMetadataCache);
    }

    public int hashCode() {
        return Objects.hash(this.timeSeriesMetadataCache);
    }
}

