/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.metric;

import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.utils.MetricInfo;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;

public class DataExchangeCountMetricSet
implements IMetricSet {
    private static final String metric = Metric.DATA_EXCHANGE_COUNT.toString();
    public static final Map<String, MetricInfo> metricInfoMap = new HashMap<String, MetricInfo>();
    public static final String SEND_NEW_DATA_BLOCK_NUM_CALLER = "send_new_data_block_num_caller";
    public static final String SEND_NEW_DATA_BLOCK_NUM_SERVER = "send_new_data_block_num_server";
    public static final String ON_ACKNOWLEDGE_DATA_BLOCK_NUM_CALLER = "on_acknowledge_data_block_num_caller";
    public static final String ON_ACKNOWLEDGE_DATA_BLOCK_NUM_SERVER = "on_acknowledge_data_block_num_server";
    public static final String GET_DATA_BLOCK_NUM_CALLER = "get_data_block_num_caller";
    public static final String GET_DATA_BLOCK_NUM_SERVER = "get_data_block_num_server";

    public void bindTo(AbstractMetricService metricService) {
        for (MetricInfo metricInfo : metricInfoMap.values()) {
            metricService.getOrCreateHistogram(metricInfo.getName(), MetricLevel.IMPORTANT, metricInfo.getTagsInArray());
        }
    }

    public void unbindFrom(AbstractMetricService metricService) {
        for (MetricInfo metricInfo : metricInfoMap.values()) {
            metricService.remove(MetricType.HISTOGRAM, metric, metricInfo.getTagsInArray());
        }
    }

    static {
        metricInfoMap.put(SEND_NEW_DATA_BLOCK_NUM_CALLER, new MetricInfo(MetricType.HISTOGRAM, metric, new String[]{Tag.NAME.toString(), "send_new_data_block_num", Tag.TYPE.toString(), "caller"}));
        metricInfoMap.put(SEND_NEW_DATA_BLOCK_NUM_SERVER, new MetricInfo(MetricType.HISTOGRAM, metric, new String[]{Tag.NAME.toString(), "send_new_data_block_num", Tag.TYPE.toString(), "server"}));
        metricInfoMap.put(ON_ACKNOWLEDGE_DATA_BLOCK_NUM_CALLER, new MetricInfo(MetricType.HISTOGRAM, metric, new String[]{Tag.NAME.toString(), "on_acknowledge_data_block_num", Tag.TYPE.toString(), "caller"}));
        metricInfoMap.put(ON_ACKNOWLEDGE_DATA_BLOCK_NUM_SERVER, new MetricInfo(MetricType.HISTOGRAM, metric, new String[]{Tag.NAME.toString(), "on_acknowledge_data_block_num", Tag.TYPE.toString(), "server"}));
        metricInfoMap.put(GET_DATA_BLOCK_NUM_CALLER, new MetricInfo(MetricType.HISTOGRAM, metric, new String[]{Tag.NAME.toString(), "get_data_block_num", Tag.TYPE.toString(), "caller"}));
        metricInfoMap.put(GET_DATA_BLOCK_NUM_SERVER, new MetricInfo(MetricType.HISTOGRAM, metric, new String[]{Tag.NAME.toString(), "get_data_block_num", Tag.TYPE.toString(), "server"}));
    }
}

