/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.schedule.queue.multilevelqueue;

import com.google.common.base.Preconditions;
import java.util.PriorityQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.db.mpp.execution.schedule.queue.IndexedBlockingReserveQueue;
import org.apache.iotdb.db.mpp.execution.schedule.queue.multilevelqueue.Priority;
import org.apache.iotdb.db.mpp.execution.schedule.task.DriverTask;

public class MultilevelPriorityQueue
extends IndexedBlockingReserveQueue<DriverTask> {
    static final int[] LEVEL_THRESHOLD_SECONDS = new int[]{0, 1, 10, 60, 300};
    static final long LEVEL_CONTRIBUTION_CAP = TimeUnit.SECONDS.toNanos(30L);
    private final PriorityQueue<DriverTask>[] levelWaitingSplits;
    private final AtomicLong[] levelScheduledTime = new AtomicLong[LEVEL_THRESHOLD_SECONDS.length];
    private final AtomicLong[] levelMinScheduledTime = new AtomicLong[LEVEL_THRESHOLD_SECONDS.length];
    private final double levelTimeMultiplier;

    public MultilevelPriorityQueue(double levelTimeMultiplier, int maxCapacity, DriverTask queryHolder) {
        super(maxCapacity, queryHolder);
        this.levelWaitingSplits = new PriorityQueue[LEVEL_THRESHOLD_SECONDS.length];
        for (int level = 0; level < LEVEL_THRESHOLD_SECONDS.length; ++level) {
            this.levelScheduledTime[level] = new AtomicLong();
            this.levelMinScheduledTime[level] = new AtomicLong(-1L);
            this.levelWaitingSplits[level] = new PriorityQueue<DriverTask>(new DriverTask.SchedulePriorityComparator());
        }
        this.levelTimeMultiplier = levelTimeMultiplier;
    }

    @Override
    public void pushToQueue(DriverTask task) {
        Preconditions.checkArgument((task != null ? 1 : 0) != 0, (Object)"DriverTask to be pushed is null");
        int level = task.getPriority().getLevel();
        if (this.levelWaitingSplits[level].isEmpty()) {
            long level0Time = this.getLevel0TargetTime();
            long levelExpectedTime = (long)((double)level0Time / Math.pow(this.levelTimeMultiplier, level));
            long delta = levelExpectedTime - this.levelScheduledTime[level].get();
            this.levelScheduledTime[level].addAndGet(delta);
        }
        this.levelWaitingSplits[level].offer(task);
    }

    @Override
    protected DriverTask pollFirst() {
        DriverTask result;
        while ((result = this.chooseLevelAndTask()).updatePriority()) {
            this.pushToQueue(result);
        }
        int selectedLevel = result.getPriority().getLevel();
        this.levelMinScheduledTime[selectedLevel].set(result.getPriority().getLevelScheduledTime());
        return result;
    }

    private DriverTask chooseLevelAndTask() {
        long targetScheduledTime = this.getLevel0TargetTime();
        double worstRatio = 1.0;
        int selectedLevel = -1;
        for (int level = 0; level < LEVEL_THRESHOLD_SECONDS.length; ++level) {
            if (!this.levelWaitingSplits[level].isEmpty()) {
                double ratio;
                long levelTime = this.levelScheduledTime[level].get();
                double d = ratio = levelTime == 0L ? 0.0 : (double)targetScheduledTime / (1.0 * (double)levelTime);
                if (selectedLevel == -1 || ratio > worstRatio) {
                    worstRatio = ratio;
                    selectedLevel = level;
                }
            }
            targetScheduledTime = (long)((double)targetScheduledTime / this.levelTimeMultiplier);
        }
        Preconditions.checkState((selectedLevel != -1 ? 1 : 0) != 0, (Object)"selected level can not equal to -1");
        DriverTask result = this.levelWaitingSplits[selectedLevel].poll();
        Preconditions.checkState((result != null ? 1 : 0) != 0, (Object)"result driverTask cannot be null");
        return result;
    }

    @Override
    protected DriverTask remove(DriverTask driverTask) {
        Preconditions.checkArgument((driverTask != null ? 1 : 0) != 0, (Object)"driverTask is null");
        for (PriorityQueue<DriverTask> level : this.levelWaitingSplits) {
            if (!level.remove(driverTask)) continue;
            return driverTask;
        }
        return null;
    }

    @Override
    protected boolean isEmpty() {
        for (PriorityQueue<DriverTask> level : this.levelWaitingSplits) {
            if (level.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean contains(DriverTask driverTask) {
        for (PriorityQueue<DriverTask> level : this.levelWaitingSplits) {
            if (!level.contains(driverTask)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected DriverTask get(DriverTask driverTask) {
        throw new UnsupportedOperationException("MultilevelPriorityQueue does not support access element by get.");
    }

    @Override
    protected void clearAllElements() {
        for (PriorityQueue<DriverTask> level : this.levelWaitingSplits) {
            level.clear();
        }
    }

    private synchronized long getLevel0TargetTime() {
        long level0TargetTime = this.levelScheduledTime[0].get();
        double currentMultiplier = this.levelTimeMultiplier;
        for (int level = 0; level < LEVEL_THRESHOLD_SECONDS.length; ++level) {
            long levelTime = this.levelScheduledTime[level].get();
            level0TargetTime = Math.max(level0TargetTime, (long)((double)levelTime / (currentMultiplier /= this.levelTimeMultiplier)));
        }
        return level0TargetTime;
    }

    private void addLevelTime(int level, long nanos) {
        this.levelScheduledTime[level].addAndGet(nanos);
    }

    public Priority updatePriority(Priority oldPriority, long quantaNanos, long scheduledNanos) {
        int oldLevel = oldPriority.getLevel();
        int newLevel = MultilevelPriorityQueue.computeLevel(scheduledNanos);
        long levelContribution = Math.min(quantaNanos, LEVEL_CONTRIBUTION_CAP);
        if (oldLevel == newLevel) {
            this.addLevelTime(oldLevel, levelContribution);
            return new Priority(oldLevel, oldPriority.getLevelScheduledTime() + quantaNanos);
        }
        long remainingLevelContribution = levelContribution;
        long remainingTaskTime = quantaNanos;
        for (int currentLevel = oldLevel; currentLevel < newLevel; ++currentLevel) {
            long timeAccruedToLevel = Math.min(TimeUnit.SECONDS.toNanos(LEVEL_THRESHOLD_SECONDS[currentLevel + 1] - LEVEL_THRESHOLD_SECONDS[currentLevel]), remainingLevelContribution);
            this.addLevelTime(currentLevel, timeAccruedToLevel);
            remainingLevelContribution -= timeAccruedToLevel;
            remainingTaskTime -= timeAccruedToLevel;
        }
        this.addLevelTime(newLevel, remainingLevelContribution);
        long newLevelMinScheduledTime = this.getLevelMinScheduledTime(newLevel, scheduledNanos);
        return new Priority(newLevel, newLevelMinScheduledTime + remainingTaskTime);
    }

    public long getLevelMinScheduledTime(int level, long taskThreadUsageNanos) {
        this.levelMinScheduledTime[level].compareAndSet(-1L, taskThreadUsageNanos);
        return this.levelMinScheduledTime[level].get();
    }

    public static int computeLevel(long threadUsageNanos) {
        long seconds = TimeUnit.NANOSECONDS.toSeconds(threadUsageNanos);
        for (int level = 0; level < LEVEL_THRESHOLD_SECONDS.length - 1; ++level) {
            if (seconds >= (long)LEVEL_THRESHOLD_SECONDS[level + 1]) continue;
            return level;
        }
        return LEVEL_THRESHOLD_SECONDS.length - 1;
    }
}

