/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.window;

import java.util.List;
import org.apache.iotdb.db.mpp.aggregation.AccumulatorFactory;
import org.apache.iotdb.db.mpp.aggregation.Aggregator;
import org.apache.iotdb.db.mpp.execution.operator.window.ConditionWindow;
import org.apache.iotdb.db.mpp.execution.operator.window.ConditionWindowParameter;
import org.apache.iotdb.db.mpp.execution.operator.window.IWindow;
import org.apache.iotdb.db.mpp.execution.operator.window.IWindowManager;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumn;

public class ConditionWindowManager
implements IWindowManager {
    private final ConditionWindow conditionWindow;
    private boolean initialized;
    private boolean needSkip;
    private boolean isFirstSkip;
    private final AccumulatorFactory.KeepEvaluator keepEvaluator;

    public ConditionWindowManager(ConditionWindowParameter conditionWindowParameter) {
        this.conditionWindow = new ConditionWindow(conditionWindowParameter);
        this.needSkip = true;
        this.keepEvaluator = AccumulatorFactory.initKeepEvaluator(conditionWindowParameter.getKeepExpression());
    }

    @Override
    public boolean isCurWindowInit() {
        return this.initialized;
    }

    @Override
    public void initCurWindow() {
        this.initialized = true;
        this.conditionWindow.setTimeInitialized(false);
        this.conditionWindow.setKeep(0L);
    }

    @Override
    public boolean hasNext(boolean hasMoreData) {
        return hasMoreData;
    }

    @Override
    public void next() {
        this.needSkip = true;
        this.initialized = false;
        this.isFirstSkip = true;
    }

    @Override
    public IWindow getCurWindow() {
        return this.conditionWindow;
    }

    @Override
    public TsBlock skipPointsOutOfCurWindow(TsBlock inputTsBlock) {
        int i;
        if (!this.needSkip) {
            return inputTsBlock;
        }
        if (inputTsBlock == null || inputTsBlock.isEmpty()) {
            return inputTsBlock;
        }
        Column controlColumn = this.conditionWindow.getControlColumn(inputTsBlock);
        TimeColumn timeColumn = inputTsBlock.getTimeColumn();
        int size = inputTsBlock.getPositionCount();
        int k = 0;
        for (i = 0; i < size; ++i) {
            if (this.isIgnoringNull() && controlColumn.isNull(i)) continue;
            if (this.isFirstSkip && (controlColumn.isNull(i) || !controlColumn.getBoolean(i)) || !this.isFirstSkip && !controlColumn.isNull(i) && controlColumn.getBoolean(i)) break;
            if (!this.isFirstSkip) continue;
            ++k;
            long currentTime = timeColumn.getLong(i);
            if (this.conditionWindow.getStartTime() > currentTime) {
                this.conditionWindow.setStartTime(currentTime);
            }
            if (this.conditionWindow.getEndTime() >= currentTime) continue;
            this.conditionWindow.setEndTime(currentTime);
        }
        if (this.isFirstSkip) {
            if (i != size) {
                this.isFirstSkip = false;
            }
            this.conditionWindow.setKeep(this.conditionWindow.getKeep() + (long)k);
            return inputTsBlock.subTsBlock(i);
        }
        if (i < size) {
            this.needSkip = false;
        }
        return inputTsBlock.subTsBlock(i);
    }

    @Override
    public TsBlockBuilder createResultTsBlockBuilder(List<Aggregator> aggregators) {
        List<TSDataType> dataTypes = this.getResultDataTypes(aggregators);
        if (this.conditionWindow.isOutputEndTime()) {
            dataTypes.add(0, TSDataType.INT64);
        }
        return new TsBlockBuilder(dataTypes);
    }

    @Override
    public void appendAggregationResult(TsBlockBuilder resultTsBlockBuilder, List<Aggregator> aggregators) {
        if (!this.keepEvaluator.apply(this.conditionWindow.getKeep())) {
            return;
        }
        long endTime = this.conditionWindow.isOutputEndTime() ? this.conditionWindow.getEndTime() : -1L;
        this.outputAggregators(aggregators, resultTsBlockBuilder, this.conditionWindow.getStartTime(), endTime);
    }

    @Override
    public boolean needSkipInAdvance() {
        return true;
    }

    @Override
    public boolean isIgnoringNull() {
        return this.conditionWindow.ignoringNull();
    }
}

