/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.schema;

import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.iotdb.db.metadata.query.info.ISchemaInfo;
import org.apache.iotdb.db.metadata.query.reader.ISchemaReader;
import org.apache.iotdb.db.metadata.schemaregion.ISchemaRegion;
import org.apache.iotdb.db.mpp.execution.driver.SchemaDriverContext;
import org.apache.iotdb.db.mpp.execution.operator.OperatorContext;
import org.apache.iotdb.db.mpp.execution.operator.schema.source.ISchemaSource;
import org.apache.iotdb.db.mpp.execution.operator.source.SourceOperator;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;

public class SchemaCountOperator<T extends ISchemaInfo>
implements SourceOperator {
    private static final List<TSDataType> OUTPUT_DATA_TYPES = Collections.singletonList(TSDataType.INT64);
    private final PlanNodeId sourceId;
    private final OperatorContext operatorContext;
    private final ISchemaSource<T> schemaSource;
    private ISchemaReader<T> schemaReader;
    private boolean isFinished;

    public SchemaCountOperator(PlanNodeId sourceId, OperatorContext operatorContext, ISchemaSource<T> schemaSource) {
        this.sourceId = sourceId;
        this.operatorContext = operatorContext;
        this.schemaSource = schemaSource;
    }

    private final ISchemaRegion getSchemaRegion() {
        return ((SchemaDriverContext)this.operatorContext.getDriverContext()).getSchemaRegion();
    }

    private ISchemaReader<T> createSchemaReader() {
        return this.schemaSource.getSchemaReader(this.getSchemaRegion());
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public TsBlock next() throws Exception {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.isFinished = true;
        TsBlockBuilder tsBlockBuilder = new TsBlockBuilder(OUTPUT_DATA_TYPES);
        long count = 0L;
        ISchemaRegion schemaRegion = this.getSchemaRegion();
        if (this.schemaSource.hasSchemaStatistic(schemaRegion)) {
            count = this.schemaSource.getSchemaStatistic(schemaRegion);
        } else {
            if (this.schemaReader == null) {
                this.schemaReader = this.createSchemaReader();
            }
            while (this.schemaReader.hasNext()) {
                this.schemaReader.next();
                ++count;
            }
            if (!this.schemaReader.isSuccess()) {
                throw new RuntimeException(this.schemaReader.getFailure());
            }
        }
        tsBlockBuilder.getTimeColumnBuilder().writeLong(0L);
        tsBlockBuilder.getColumnBuilder(0).writeLong(count);
        tsBlockBuilder.declarePosition();
        return tsBlockBuilder.build();
    }

    @Override
    public boolean hasNext() throws Exception {
        return !this.isFinished;
    }

    @Override
    public boolean isFinished() throws Exception {
        return this.isFinished;
    }

    @Override
    public long calculateMaxPeekMemory() {
        return 8L;
    }

    @Override
    public long calculateMaxReturnSize() {
        return 8L;
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        return 0L;
    }

    @Override
    public PlanNodeId getSourceId() {
        return this.sourceId;
    }

    @Override
    public void close() throws Exception {
        if (this.schemaReader != null) {
            this.schemaReader.close();
            this.schemaReader = null;
        }
    }
}

