/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.process;

import java.util.List;
import org.apache.iotdb.db.mpp.aggregation.Aggregator;
import org.apache.iotdb.db.mpp.aggregation.timerangeiterator.ITimeRangeIterator;
import org.apache.iotdb.db.mpp.execution.operator.AggregationUtil;
import org.apache.iotdb.db.mpp.execution.operator.Operator;
import org.apache.iotdb.db.mpp.execution.operator.OperatorContext;
import org.apache.iotdb.db.mpp.execution.operator.process.SingleInputAggregationOperator;
import org.apache.iotdb.db.mpp.execution.operator.window.IWindow;
import org.apache.iotdb.db.mpp.execution.operator.window.IWindowManager;
import org.apache.iotdb.db.mpp.execution.operator.window.WindowManagerFactory;
import org.apache.iotdb.db.mpp.execution.operator.window.WindowParameter;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.utils.BitMap;

public class RawDataAggregationOperator
extends SingleInputAggregationOperator {
    private final IWindowManager windowManager;
    private boolean needSkip = false;
    private boolean hasCachedDataInAggregator = false;

    public RawDataAggregationOperator(OperatorContext operatorContext, List<Aggregator> aggregators, ITimeRangeIterator timeRangeIterator, Operator child, boolean ascending, long maxReturnSize, WindowParameter windowParameter) {
        super(operatorContext, aggregators, child, ascending, maxReturnSize);
        this.windowManager = WindowManagerFactory.genWindowManager(windowParameter, timeRangeIterator, ascending);
        this.resultTsBlockBuilder = this.windowManager.createResultTsBlockBuilder(aggregators);
    }

    private boolean hasMoreData() throws Exception {
        return this.inputTsBlock != null && !this.inputTsBlock.isEmpty() || this.child.hasNextWithTimer() || this.hasCachedDataInAggregator;
    }

    @Override
    public boolean hasNext() throws Exception {
        return this.windowManager.hasNext(this.hasMoreData());
    }

    @Override
    protected boolean calculateNextAggregationResult() throws Exception {
        while (this.needSkip || !this.calculateFromRawData()) {
            this.inputTsBlock = null;
            if (this.child.hasNextWithTimer() && this.canCallNext) {
                this.inputTsBlock = this.child.nextWithTimer();
                this.canCallNext = false;
                if (!this.needSkip) continue;
                break;
            }
            if (this.child.hasNextWithTimer()) {
                return false;
            }
            if (this.windowManager.notInitializedLastTimeWindow()) {
                this.initWindowAndAggregators();
            }
            if (this.needSkip || this.windowManager.isCurWindowInit()) break;
            return false;
        }
        if (!this.needSkip) {
            this.windowManager.next();
        }
        if (this.windowManager.needSkipInAdvance()) {
            this.needSkip = true;
            this.inputTsBlock = this.windowManager.skipPointsOutOfCurWindow(this.inputTsBlock);
            if ((this.inputTsBlock == null || this.inputTsBlock.isEmpty()) && this.child.hasNextWithTimer()) {
                return this.canCallNext;
            }
            this.needSkip = false;
        }
        this.updateResultTsBlock();
        this.hasCachedDataInAggregator = false;
        return true;
    }

    private boolean calculateFromRawData() {
        if (!this.windowManager.isCurWindowInit() && !this.skipPreviousWindowAndInitCurWindow()) {
            return false;
        }
        if (this.inputTsBlock == null || this.inputTsBlock.isEmpty()) {
            return false;
        }
        if (this.windowManager.satisfiedCurWindow(this.inputTsBlock)) {
            int tsBlockSize = this.inputTsBlock.getPositionCount();
            IWindow curWindow = this.windowManager.getCurWindow();
            Column[] controlAndTimeColumn = new Column[]{curWindow.getControlColumn(this.inputTsBlock), this.inputTsBlock.getTimeColumn()};
            BitMap needProcess = new BitMap(tsBlockSize);
            int lastIndexToProcess = -1;
            boolean hasSkip = false;
            for (int i = 0; i < tsBlockSize; ++i) {
                if (this.windowManager.isIgnoringNull() && controlAndTimeColumn[0].isNull(i)) {
                    lastIndexToProcess = i;
                    hasSkip = true;
                    continue;
                }
                if (!curWindow.satisfy(controlAndTimeColumn[0], i)) break;
                needProcess.mark(i);
                curWindow.mergeOnePoint(controlAndTimeColumn, i);
                lastIndexToProcess = i;
            }
            if (!hasSkip) {
                needProcess = null;
            }
            for (Aggregator aggregator : this.aggregators) {
                if (aggregator.hasFinalResult()) continue;
                aggregator.processTsBlock(this.inputTsBlock, needProcess, lastIndexToProcess);
            }
            int lastReadRowIndex = lastIndexToProcess + 1;
            if (lastReadRowIndex != 0) {
                this.hasCachedDataInAggregator = true;
            }
            if (lastReadRowIndex >= this.inputTsBlock.getPositionCount()) {
                this.inputTsBlock = null;
                return AggregationUtil.isAllAggregatorsHasFinalResult(this.aggregators);
            }
            this.inputTsBlock = this.inputTsBlock.subTsBlock(lastReadRowIndex);
            return true;
        }
        boolean isTsBlockOutOfBound = this.windowManager.isTsBlockOutOfBound(this.inputTsBlock);
        return AggregationUtil.isAllAggregatorsHasFinalResult(this.aggregators) || isTsBlockOutOfBound;
    }

    @Override
    protected void updateResultTsBlock() {
        this.windowManager.appendAggregationResult(this.resultTsBlockBuilder, this.aggregators);
    }

    private boolean skipPreviousWindowAndInitCurWindow() {
        this.inputTsBlock = this.windowManager.skipPointsOutOfCurWindow(this.inputTsBlock);
        if (this.inputTsBlock == null || this.inputTsBlock.isEmpty()) {
            return false;
        }
        this.initWindowAndAggregators();
        return true;
    }

    private void initWindowAndAggregators() {
        this.windowManager.initCurWindow();
        for (Aggregator aggregator : this.aggregators) {
            aggregator.reset();
        }
    }
}

