/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.process;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.db.mpp.execution.operator.Operator;
import org.apache.iotdb.db.mpp.execution.operator.OperatorContext;
import org.apache.iotdb.db.mpp.execution.operator.process.AbstractConsumeAllOperator;
import org.apache.iotdb.db.utils.datastructure.MergeSortHeap;
import org.apache.iotdb.db.utils.datastructure.MergeSortKey;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumnBuilder;

public class MergeSortOperator
extends AbstractConsumeAllOperator {
    private final List<TSDataType> dataTypes;
    private final TsBlockBuilder tsBlockBuilder;
    private final boolean[] noMoreTsBlocks;
    private final MergeSortHeap mergeSortHeap;
    private final Comparator<MergeSortKey> comparator;
    private boolean finished;

    public MergeSortOperator(OperatorContext operatorContext, List<Operator> inputOperators, List<TSDataType> dataTypes, Comparator<MergeSortKey> comparator) {
        super(operatorContext, inputOperators);
        this.dataTypes = dataTypes;
        this.mergeSortHeap = new MergeSortHeap(this.inputOperatorsCount, comparator);
        this.comparator = comparator;
        this.noMoreTsBlocks = new boolean[this.inputOperatorsCount];
        this.tsBlockBuilder = new TsBlockBuilder(dataTypes);
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        boolean hasReadyChild = false;
        ArrayList listenableFutures = new ArrayList();
        for (int i = 0; i < this.inputOperatorsCount; ++i) {
            if (this.noMoreTsBlocks[i] || !this.isEmpty(i)) continue;
            ListenableFuture<?> blocked = ((Operator)this.children.get(i)).isBlocked();
            if (blocked.isDone()) {
                hasReadyChild = true;
                this.canCallNext[i] = true;
                continue;
            }
            listenableFutures.add(blocked);
        }
        return hasReadyChild || listenableFutures.isEmpty() ? NOT_BLOCKED : Futures.successfulAsList(listenableFutures);
    }

    @Override
    public TsBlock next() throws Exception {
        long startTime = System.nanoTime();
        long maxRuntime = this.operatorContext.getMaxRunTime().roundTo(TimeUnit.NANOSECONDS);
        if (!this.prepareInput()) {
            return null;
        }
        MergeSortKey minMergeSortKey = this.mergeSortHeap.poll();
        if (this.mergeSortHeap.isEmpty() || this.comparator.compare(new MergeSortKey(minMergeSortKey.tsBlock, minMergeSortKey.tsBlock.getPositionCount() - 1), this.mergeSortHeap.peek()) < 0) {
            this.inputTsBlocks[minMergeSortKey.columnIndex] = null;
            return minMergeSortKey.rowIndex == 0 ? minMergeSortKey.tsBlock : minMergeSortKey.tsBlock.subTsBlock(minMergeSortKey.rowIndex);
        }
        this.mergeSortHeap.push(minMergeSortKey);
        this.tsBlockBuilder.reset();
        TimeColumnBuilder timeBuilder = this.tsBlockBuilder.getTimeColumnBuilder();
        ColumnBuilder[] valueColumnBuilders = this.tsBlockBuilder.getValueColumnBuilders();
        while (!this.mergeSortHeap.isEmpty()) {
            MergeSortKey mergeSortKey = this.mergeSortHeap.poll();
            TsBlock targetBlock = mergeSortKey.tsBlock;
            int rowIndex = mergeSortKey.rowIndex;
            timeBuilder.writeLong(targetBlock.getTimeByIndex(rowIndex));
            for (int i = 0; i < valueColumnBuilders.length; ++i) {
                if (targetBlock.getColumn(i).isNull(rowIndex)) {
                    valueColumnBuilders[i].appendNull();
                    continue;
                }
                valueColumnBuilders[i].write(targetBlock.getColumn(i), rowIndex);
            }
            this.tsBlockBuilder.declarePosition();
            if (mergeSortKey.rowIndex == mergeSortKey.tsBlock.getPositionCount() - 1) {
                this.inputTsBlocks[mergeSortKey.columnIndex] = null;
                if (!this.mergeSortHeap.isEmpty() && this.comparator.compare(this.mergeSortHeap.peek(), mergeSortKey) > 0) {
                    break;
                }
            } else {
                ++mergeSortKey.rowIndex;
                this.mergeSortHeap.push(mergeSortKey);
            }
            if (System.nanoTime() - startTime <= maxRuntime && !this.tsBlockBuilder.isFull()) continue;
            break;
        }
        return this.tsBlockBuilder.build();
    }

    @Override
    public boolean hasNext() throws Exception {
        if (this.finished) {
            return false;
        }
        for (int i = 0; i < this.inputOperatorsCount; ++i) {
            if (!this.isEmpty(i)) {
                return true;
            }
            if (this.noMoreTsBlocks[i]) continue;
            if (!this.canCallNext[i] || ((Operator)this.children.get(i)).hasNextWithTimer()) {
                return true;
            }
            this.noMoreTsBlocks[i] = true;
            this.inputTsBlocks[i] = null;
        }
        return false;
    }

    @Override
    public boolean isFinished() throws Exception {
        if (this.finished) {
            return true;
        }
        this.finished = true;
        for (int i = 0; i < this.inputOperatorsCount; ++i) {
            if (this.noMoreTsBlocks[i] && this.isEmpty(i)) continue;
            this.finished = false;
            break;
        }
        return this.finished;
    }

    @Override
    public long calculateMaxPeekMemory() {
        long maxPeekMemory = TSFileDescriptor.getInstance().getConfig().getPageSizeInByte();
        for (Operator operator : this.children) {
            maxPeekMemory += operator.calculateMaxReturnSize();
            maxPeekMemory += operator.calculateRetainedSizeAfterCallingNext();
        }
        for (Operator operator : this.children) {
            maxPeekMemory = Math.max(maxPeekMemory, operator.calculateMaxPeekMemory());
        }
        return Math.max(maxPeekMemory, this.calculateMaxReturnSize());
    }

    @Override
    public long calculateMaxReturnSize() {
        return (1L + (long)this.dataTypes.size()) * (long)TSFileDescriptor.getInstance().getConfig().getPageSizeInByte();
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        long currentRetainedSize = 0L;
        long minChildReturnSize = Long.MAX_VALUE;
        for (Operator child : this.children) {
            long maxReturnSize = child.calculateMaxReturnSize();
            minChildReturnSize = Math.min(minChildReturnSize, maxReturnSize);
            currentRetainedSize += maxReturnSize + child.calculateRetainedSizeAfterCallingNext();
        }
        return currentRetainedSize - minChildReturnSize;
    }

    @Override
    protected boolean prepareInput() throws Exception {
        boolean allReady = true;
        for (int i = 0; i < this.inputOperatorsCount; ++i) {
            if (this.noMoreTsBlocks[i] || !this.isEmpty(i)) continue;
            if (this.canCallNext[i]) {
                if (((Operator)this.children.get(i)).hasNextWithTimer()) {
                    this.inputTsBlocks[i] = this.getNextTsBlock(i);
                    this.canCallNext[i] = false;
                    if (this.isEmpty(i)) {
                        allReady = false;
                        continue;
                    }
                    this.mergeSortHeap.push(new MergeSortKey(this.inputTsBlocks[i], 0, i));
                    continue;
                }
                this.noMoreTsBlocks[i] = true;
                this.inputTsBlocks[i] = null;
                continue;
            }
            allReady = false;
        }
        return allReady;
    }
}

