/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.executor;

import org.apache.iotdb.commons.consensus.ConsensusGroupId;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.consensus.common.request.IConsensusRequest;
import org.apache.iotdb.consensus.common.response.ConsensusReadResponse;
import org.apache.iotdb.db.consensus.DataRegionConsensusImpl;
import org.apache.iotdb.db.consensus.SchemaRegionConsensusImpl;
import org.apache.iotdb.db.engine.storagegroup.VirtualDataRegion;
import org.apache.iotdb.db.mpp.execution.executor.RegionExecutionResult;
import org.apache.iotdb.db.mpp.execution.fragment.FragmentInstanceInfo;
import org.apache.iotdb.db.mpp.execution.fragment.FragmentInstanceManager;
import org.apache.iotdb.db.mpp.plan.planner.plan.FragmentInstance;
import org.apache.iotdb.db.utils.SetThreadName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegionReadExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(RegionReadExecutor.class);

    public RegionExecutionResult execute(ConsensusGroupId groupId, FragmentInstance fragmentInstance) {
        SetThreadName threadName = new SetThreadName(fragmentInstance.getId().getFullId());
        try {
            ConsensusReadResponse readResponse = groupId instanceof DataRegionId ? DataRegionConsensusImpl.getInstance().read(groupId, (IConsensusRequest)fragmentInstance) : SchemaRegionConsensusImpl.getInstance().read(groupId, (IConsensusRequest)fragmentInstance);
            RegionExecutionResult resp = new RegionExecutionResult();
            if (readResponse == null) {
                LOGGER.error("ReadResponse is null");
                resp.setAccepted(false);
                resp.setMessage("ReadResponse is null");
            } else if (!readResponse.isSuccess()) {
                LOGGER.error("Execute FragmentInstance in ConsensusGroup {} failed.", (Object)groupId, (Object)readResponse.getException());
                resp.setAccepted(false);
                resp.setMessage("Execute FragmentInstance failed: " + (readResponse.getException() == null ? "" : readResponse.getException().getMessage()));
            } else {
                FragmentInstanceInfo info = (FragmentInstanceInfo)readResponse.getDataset();
                resp.setAccepted(!info.getState().isFailed());
                resp.setMessage(info.getMessage());
            }
            RegionExecutionResult regionExecutionResult = resp;
            threadName.close();
            return regionExecutionResult;
        }
        catch (Throwable resp) {
            try {
                try {
                    threadName.close();
                }
                catch (Throwable throwable) {
                    resp.addSuppressed(throwable);
                }
                throw resp;
            }
            catch (Throwable t) {
                LOGGER.error("Execute FragmentInstance in ConsensusGroup {} failed.", (Object)groupId, (Object)t);
                RegionExecutionResult resp2 = new RegionExecutionResult();
                resp2.setAccepted(false);
                resp2.setMessage("Execute FragmentInstance failed: " + t.getMessage());
                return resp2;
            }
        }
    }

    public RegionExecutionResult execute(FragmentInstance fragmentInstance) {
        SetThreadName threadName = new SetThreadName(fragmentInstance.getId().getFullId());
        try {
            RegionExecutionResult resp = new RegionExecutionResult();
            FragmentInstanceInfo info = FragmentInstanceManager.getInstance().execDataQueryFragmentInstance(fragmentInstance, VirtualDataRegion.getInstance());
            resp.setAccepted(!info.getState().isFailed());
            resp.setMessage(info.getMessage());
            RegionExecutionResult regionExecutionResult = resp;
            threadName.close();
            return regionExecutionResult;
        }
        catch (Throwable resp) {
            try {
                try {
                    threadName.close();
                }
                catch (Throwable throwable) {
                    resp.addSuppressed(throwable);
                }
                throw resp;
            }
            catch (Throwable t) {
                LOGGER.error("Execute FragmentInstance in QueryExecutor failed.", t);
                RegionExecutionResult resp2 = new RegionExecutionResult();
                resp2.setAccepted(false);
                resp2.setMessage("Execute FragmentInstance failed: " + t.getMessage());
                return resp2;
            }
        }
    }
}

