/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.aggregation;

import com.google.common.base.Preconditions;
import org.apache.iotdb.db.mpp.aggregation.Accumulator;
import org.apache.iotdb.db.mpp.aggregation.AccumulatorFactory;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.tsfile.utils.BitMap;

public class CountIfAccumulator
implements Accumulator {
    private long countValue = 0L;
    private long keep;
    private final AccumulatorFactory.KeepEvaluator keepEvaluator;
    private final boolean ignoreNull;
    private boolean lastPointIsSatisfy;

    public CountIfAccumulator(AccumulatorFactory.KeepEvaluator keepEvaluator, boolean ignoreNull) {
        this.keepEvaluator = keepEvaluator;
        this.ignoreNull = ignoreNull;
    }

    @Override
    public void addInput(Column[] column, BitMap bitMap, int lastIndex) {
        for (int i = 0; i <= lastIndex; ++i) {
            if (bitMap != null && !bitMap.isMarked(i)) continue;
            if (column[1].isNull(i)) {
                if (this.ignoreNull) continue;
                if (this.lastPointIsSatisfy && this.keepEvaluator.apply(this.keep)) {
                    ++this.countValue;
                }
                this.keep = 0L;
                this.lastPointIsSatisfy = false;
                continue;
            }
            if (column[1].getBoolean(i)) {
                ++this.keep;
                this.lastPointIsSatisfy = true;
                continue;
            }
            if (this.lastPointIsSatisfy && this.keepEvaluator.apply(this.keep)) {
                ++this.countValue;
            }
            this.keep = 0L;
            this.lastPointIsSatisfy = false;
        }
    }

    @Override
    public void addIntermediate(Column[] partialResult) {
        Preconditions.checkArgument((partialResult.length == 1 ? 1 : 0) != 0, (Object)"partialResult of count_if should be 1");
        if (partialResult[0].isNull(0)) {
            return;
        }
        this.countValue += partialResult[0].getLong(0);
    }

    @Override
    public void addStatistics(Statistics statistics) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public void setFinal(Column finalResult) {
        if (finalResult.isNull(0)) {
            return;
        }
        this.countValue = finalResult.getLong(0);
    }

    @Override
    public void outputIntermediate(ColumnBuilder[] columnBuilders) {
        Preconditions.checkArgument((columnBuilders.length == 1 ? 1 : 0) != 0, (Object)"partialResult of count_if should be 1");
        if (this.lastPointIsSatisfy && this.keepEvaluator.apply(this.keep)) {
            ++this.countValue;
        }
        columnBuilders[0].writeLong(this.countValue);
    }

    @Override
    public void outputFinal(ColumnBuilder columnBuilder) {
        if (this.lastPointIsSatisfy && this.keepEvaluator.apply(this.keep)) {
            ++this.countValue;
        }
        columnBuilder.writeLong(this.countValue);
    }

    @Override
    public void reset() {
        this.countValue = 0L;
        this.keep = 0L;
    }

    @Override
    public boolean hasFinalResult() {
        return false;
    }

    @Override
    public TSDataType[] getIntermediateType() {
        return new TSDataType[]{TSDataType.INT64};
    }

    @Override
    public TSDataType getFinalType() {
        return TSDataType.INT64;
    }
}

