/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.tag;

import java.io.File;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TagLogFile
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(TagLogFile.class);
    private File tagFile;
    private FileChannel fileChannel;
    private static final String LENGTH_EXCEED_MSG = "Tag/Attribute exceeds the max length limit. Please enlarge tag_attribute_total_size in iotdb-common.properties";
    private static final int MAX_LENGTH = IoTDBDescriptor.getInstance().getConfig().getTagAttributeTotalSize();
    private static final int RECORD_FLUSH_INTERVAL = IoTDBDescriptor.getInstance().getConfig().getTagAttributeFlushInterval();
    private int unFlushedRecordNum = 0;

    public TagLogFile(String schemaDir, String logFileName) throws IOException {
        File metadataDir = SystemFileFactory.INSTANCE.getFile(schemaDir);
        if (!metadataDir.exists()) {
            if (metadataDir.mkdirs()) {
                logger.info("create schema folder {}.", (Object)metadataDir);
            } else {
                logger.info("create schema folder {} failed.", (Object)metadataDir);
            }
        }
        this.tagFile = SystemFileFactory.INSTANCE.getFile(schemaDir + File.separator + logFileName);
        this.fileChannel = FileChannel.open(this.tagFile.toPath(), StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
        try {
            this.fileChannel.position(this.fileChannel.size());
        }
        catch (ClosedByInterruptException closedByInterruptException) {
            // empty catch block
        }
    }

    public synchronized void copyTo(File targetFile) throws IOException {
        this.fileChannel.force(true);
        FileUtils.copyFile((File)this.tagFile, (File)targetFile);
    }

    public Pair<Map<String, String>, Map<String, String>> read(int size, long position) throws IOException {
        if (position < 0L) {
            return new Pair(Collections.emptyMap(), Collections.emptyMap());
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(size);
        this.fileChannel.read(byteBuffer, position);
        byteBuffer.flip();
        return new Pair((Object)ReadWriteIOUtils.readMap((ByteBuffer)byteBuffer), (Object)ReadWriteIOUtils.readMap((ByteBuffer)byteBuffer));
    }

    public Map<String, String> readTag(int size, long position) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(size);
        this.fileChannel.read(byteBuffer, position);
        byteBuffer.flip();
        return ReadWriteIOUtils.readMap((ByteBuffer)byteBuffer);
    }

    public long write(Map<String, String> tagMap, Map<String, String> attributeMap) throws IOException, MetadataException {
        ByteBuffer byteBuffer = this.convertMapToByteBuffer(tagMap, attributeMap);
        return this.write(byteBuffer, -1L);
    }

    public void write(Map<String, String> tagMap, Map<String, String> attributeMap, long position) throws IOException, MetadataException {
        ByteBuffer byteBuffer = this.convertMapToByteBuffer(tagMap, attributeMap);
        this.write(byteBuffer, position);
    }

    private synchronized long write(ByteBuffer byteBuffer, long position) throws IOException {
        if (position < 0L) {
            position = this.fileChannel.size();
        }
        this.fileChannel.write(byteBuffer, position);
        ++this.unFlushedRecordNum;
        if (this.unFlushedRecordNum >= RECORD_FLUSH_INTERVAL) {
            this.fileChannel.force(true);
            this.unFlushedRecordNum = 0;
        }
        return position;
    }

    private ByteBuffer convertMapToByteBuffer(Map<String, String> tagMap, Map<String, String> attributeMap) throws MetadataException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(MAX_LENGTH);
        this.serializeMap(tagMap, byteBuffer);
        this.serializeMap(attributeMap, byteBuffer);
        byteBuffer.position(0);
        return byteBuffer;
    }

    private void serializeMap(Map<String, String> map, ByteBuffer byteBuffer) throws MetadataException {
        try {
            if (map == null) {
                ReadWriteIOUtils.write((int)0, (ByteBuffer)byteBuffer);
            } else {
                ReadWriteIOUtils.write(map, (ByteBuffer)byteBuffer);
            }
        }
        catch (BufferOverflowException e) {
            throw new MetadataException(LENGTH_EXCEED_MSG);
        }
    }

    @Override
    public void close() throws IOException {
        this.fileChannel.force(true);
        this.fileChannel.close();
        this.fileChannel = null;
    }
}

