/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.rescon;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.commons.schema.ClusterSchemaQuotaLevel;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.metadata.SchemaQuotaExceededException;

public class DataNodeSchemaQuotaManager {
    private ClusterSchemaQuotaLevel level = ClusterSchemaQuotaLevel.valueOf((String)IoTDBDescriptor.getInstance().getConfig().getClusterSchemaLimitLevel().toUpperCase());
    private long limit = IoTDBDescriptor.getInstance().getConfig().getClusterSchemaLimitThreshold();
    private final AtomicLong remain = new AtomicLong(0L);

    public void updateRemain(long totalCount) {
        this.remain.getAndSet(this.limit - totalCount);
    }

    public void checkMeasurementLevel(int acquireNumber) throws SchemaQuotaExceededException {
        if (this.limit > 0L && this.level.equals((Object)ClusterSchemaQuotaLevel.TIMESERIES)) {
            if (this.remain.get() <= 0L) {
                throw new SchemaQuotaExceededException(this.level, this.limit);
            }
            this.remain.addAndGet(-acquireNumber);
        }
    }

    public void checkDeviceLevel() throws SchemaQuotaExceededException {
        if (this.limit > 0L && this.level.equals((Object)ClusterSchemaQuotaLevel.DEVICE)) {
            if (this.remain.get() <= 0L) {
                throw new SchemaQuotaExceededException(this.level, this.limit);
            }
            this.remain.addAndGet(-1L);
        }
    }

    public void updateConfiguration() {
        this.level = ClusterSchemaQuotaLevel.valueOf((String)IoTDBDescriptor.getInstance().getConfig().getClusterSchemaLimitLevel().toUpperCase());
        long oldLimit = this.limit;
        this.limit = IoTDBDescriptor.getInstance().getConfig().getClusterSchemaLimitThreshold();
        this.remain.addAndGet(this.limit - oldLimit);
    }

    public ClusterSchemaQuotaLevel getLevel() {
        return this.level;
    }

    public long getLimit() {
        return this.limit;
    }

    private DataNodeSchemaQuotaManager() {
    }

    public static DataNodeSchemaQuotaManager getInstance() {
        return DataNodeSchemaQuotaManagerHolder.INSTANCE;
    }

    private static class DataNodeSchemaQuotaManagerHolder {
        private static final DataNodeSchemaQuotaManager INSTANCE = new DataNodeSchemaQuotaManager();

        private DataNodeSchemaQuotaManagerHolder() {
        }
    }
}

