/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mtree.store.disk.memcontrol;

import java.util.List;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mtree.store.disk.memcontrol.CachedMNodeSizeEstimator;
import org.apache.iotdb.db.metadata.rescon.CachedSchemaRegionStatistics;

public class MemManager {
    private final CachedSchemaRegionStatistics regionStatistics;
    private final CachedMNodeSizeEstimator estimator = new CachedMNodeSizeEstimator();

    public MemManager(CachedSchemaRegionStatistics regionStatistics) {
        this.regionStatistics = regionStatistics;
    }

    public void requestPinnedMemResource(IMNode node) {
        int size = this.estimator.estimateSize(node);
        this.regionStatistics.requestMemory(size);
        this.regionStatistics.updatePinnedMemorySize(size);
        this.regionStatistics.updatePinnedMNodeNum(1);
    }

    public void upgradeMemResource(IMNode node) {
        int size = this.estimator.estimateSize(node);
        this.regionStatistics.updatePinnedMemorySize(size);
        this.regionStatistics.updatePinnedMNodeNum(1);
        this.regionStatistics.updateUnpinnedMemorySize(-size);
        this.regionStatistics.updateUnpinnedMNodeNum(-1);
    }

    public void releasePinnedMemResource(IMNode node) {
        int size = this.estimator.estimateSize(node);
        this.regionStatistics.updateUnpinnedMemorySize(size);
        this.regionStatistics.updateUnpinnedMNodeNum(1);
        this.regionStatistics.updatePinnedMemorySize(-size);
        this.regionStatistics.updatePinnedMNodeNum(-1);
    }

    public void releaseMemResource(IMNode node) {
        int size = this.estimator.estimateSize(node);
        this.regionStatistics.updateUnpinnedMemorySize(-size);
        this.regionStatistics.updateUnpinnedMNodeNum(-1);
        this.regionStatistics.releaseMemory(size);
    }

    public void releaseMemResource(List<IMNode> evictedNodes) {
        int size = 0;
        for (IMNode node : evictedNodes) {
            size += this.estimator.estimateSize(node);
        }
        this.regionStatistics.updateUnpinnedMNodeNum(-evictedNodes.size());
        this.regionStatistics.updateUnpinnedMemorySize(-size);
        this.regionStatistics.releaseMemory(size);
    }

    public void updatePinnedSize(int deltaSize) {
        if (deltaSize > 0) {
            this.regionStatistics.requestMemory(deltaSize);
        } else {
            this.regionStatistics.releaseMemory(-deltaSize);
        }
        this.regionStatistics.updatePinnedMemorySize(deltaSize);
    }
}

