/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.logfile;

import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import org.apache.iotdb.db.metadata.logfile.MLogDescription;

public class MLogDescriptionWriter {
    private final FileChannel fileChannel;
    private final MLogDescription mLogDescription;

    public MLogDescriptionWriter(String schemaDir, String logFileName) throws IOException {
        File file = new File(schemaDir, logFileName);
        if (!file.exists() && !file.createNewFile()) {
            throw new IOException(String.format("Failed to create file %s because the named file already exists", file.getName()));
        }
        this.fileChannel = FileChannel.open(new File(schemaDir, logFileName).toPath(), StandardOpenOption.WRITE);
        this.mLogDescription = new MLogDescription();
    }

    public synchronized void updateCheckPoint(long checkPoint) throws IOException {
        this.mLogDescription.setCheckPoint(checkPoint);
        this.mLogDescription.serialize(this.fileChannel);
    }

    public synchronized void close() throws IOException {
        this.fileChannel.close();
    }
}

