/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.db.engine.compaction.execute.task.AbstractCompactionTask;
import org.apache.iotdb.db.engine.compaction.execute.task.CompactionTaskSummary;
import org.apache.iotdb.db.engine.compaction.execute.task.InnerSpaceCompactionTask;
import org.apache.iotdb.db.engine.compaction.schedule.CompactionTaskManager;

public class TsFileMetricManager {
    private static final TsFileMetricManager INSTANCE = new TsFileMetricManager();
    private final AtomicLong seqFileSize = new AtomicLong(0L);
    private final AtomicLong unseqFileSize = new AtomicLong(0L);
    private final AtomicInteger seqFileNum = new AtomicInteger(0);
    private final AtomicInteger unseqFileNum = new AtomicInteger(0);
    private final AtomicInteger modFileNum = new AtomicInteger(0);
    private final AtomicLong modFileSize = new AtomicLong(0L);
    private long lastUpdateTime = 0L;
    private static final long UPDATE_INTERVAL = 10000L;
    private final AtomicLong innerSeqCompactionTempFileSize = new AtomicLong(0L);
    private final AtomicLong innerUnseqCompactionTempFileSize = new AtomicLong(0L);
    private final AtomicLong crossCompactionTempFileSize = new AtomicLong(0L);
    private final AtomicInteger innerSeqCompactionTempFileNum = new AtomicInteger(0);
    private final AtomicInteger innerUnseqCompactionTempFileNum = new AtomicInteger(0);
    private final AtomicInteger crossCompactionTempFileNum = new AtomicInteger(0);

    private TsFileMetricManager() {
    }

    public static TsFileMetricManager getInstance() {
        return INSTANCE;
    }

    public void addFile(long size, boolean seq) {
        if (seq) {
            this.seqFileSize.getAndAdd(size);
            this.seqFileNum.incrementAndGet();
        } else {
            this.unseqFileSize.getAndAdd(size);
            this.unseqFileNum.incrementAndGet();
        }
    }

    public void deleteFile(long size, boolean seq, int num) {
        if (seq) {
            this.seqFileSize.getAndAdd(-size);
            this.seqFileNum.getAndAdd(-num);
        } else {
            this.unseqFileSize.getAndAdd(-size);
            this.unseqFileNum.getAndAdd(-num);
        }
    }

    public long getFileSize(boolean seq) {
        return seq ? this.seqFileSize.get() : this.unseqFileSize.get();
    }

    public long getFileNum(boolean seq) {
        return seq ? (long)this.seqFileNum.get() : (long)this.unseqFileNum.get();
    }

    public int getModFileNum() {
        return this.modFileNum.get();
    }

    public long getModFileSize() {
        return this.modFileSize.get();
    }

    public void increaseModFileNum(int num) {
        this.modFileNum.addAndGet(num);
    }

    public void decreaseModFileNum(int num) {
        this.modFileNum.addAndGet(-num);
    }

    public void increaseModFileSize(long size) {
        this.modFileSize.addAndGet(size);
    }

    public void decreaseModFileSize(long size) {
        this.modFileSize.addAndGet(-size);
    }

    public long getInnerCompactionTempFileSize(boolean seq) {
        this.updateCompactionTempSize();
        return seq ? this.innerSeqCompactionTempFileSize.get() : this.innerUnseqCompactionTempFileSize.get();
    }

    private synchronized void updateCompactionTempSize() {
        if (System.currentTimeMillis() - this.lastUpdateTime <= 10000L) {
            return;
        }
        this.lastUpdateTime = System.currentTimeMillis();
        this.innerSeqCompactionTempFileSize.set(0L);
        this.innerSeqCompactionTempFileNum.set(0);
        this.innerUnseqCompactionTempFileSize.set(0L);
        this.innerUnseqCompactionTempFileNum.set(0);
        this.crossCompactionTempFileSize.set(0L);
        this.crossCompactionTempFileNum.set(0);
        List<AbstractCompactionTask> runningTasks = CompactionTaskManager.getInstance().getRunningCompactionTaskList();
        for (AbstractCompactionTask task : runningTasks) {
            CompactionTaskSummary summary = task.getSummary();
            if (task instanceof InnerSpaceCompactionTask) {
                if (task.isInnerSeqTask()) {
                    this.innerSeqCompactionTempFileSize.addAndGet(summary.getTemporalFileSize());
                    this.innerSeqCompactionTempFileNum.addAndGet(1);
                    continue;
                }
                this.innerUnseqCompactionTempFileSize.addAndGet(summary.getTemporalFileSize());
                this.innerUnseqCompactionTempFileNum.addAndGet(1);
                continue;
            }
            this.crossCompactionTempFileSize.addAndGet(summary.getTemporalFileSize());
            this.crossCompactionTempFileNum.addAndGet(summary.getTemporalFileNum());
        }
    }

    public long getCrossCompactionTempFileSize() {
        this.updateCompactionTempSize();
        return this.crossCompactionTempFileSize.get();
    }

    public long getInnerCompactionTempFileNum(boolean seq) {
        this.updateCompactionTempSize();
        return seq ? (long)this.innerSeqCompactionTempFileNum.get() : (long)this.innerUnseqCompactionTempFileNum.get();
    }

    public long getCrossCompactionTempFileNum() {
        this.updateCompactionTempSize();
        return this.crossCompactionTempFileNum.get();
    }
}

