/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.common.rpc.thrift.TAggregationType;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.mpp.plan.statement.component.Ordering;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;

public class SchemaUtils {
    private static final Map<TSDataType, Set<TSEncoding>> schemaChecker = new EnumMap<TSDataType, Set<TSEncoding>>(TSDataType.class);

    private SchemaUtils() {
    }

    public static List<TSDataType> getSeriesTypesByPaths(Collection<? extends PartialPath> paths) {
        ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
        for (PartialPath partialPath : paths) {
            dataTypes.add(partialPath == null ? null : partialPath.getSeriesType());
        }
        return dataTypes;
    }

    public static List<TSDataType> getAggregatedDataTypes(List<TSDataType> measurementDataType, String aggregation) {
        TSDataType dataType = SchemaUtils.getAggregationType(aggregation);
        if (dataType != null) {
            return Collections.nCopies(measurementDataType.size(), dataType);
        }
        return measurementDataType;
    }

    public static TSDataType getSeriesTypeByPath(PartialPath path, String aggregation) {
        TSDataType dataType = SchemaUtils.getAggregationType(aggregation);
        if (dataType != null) {
            return dataType;
        }
        return path.getSeriesType();
    }

    public static TSDataType getAggregationType(String aggregation) {
        if (aggregation == null) {
            return null;
        }
        switch (aggregation.toLowerCase()) {
            case "min_time": 
            case "max_time": 
            case "count": {
                return TSDataType.INT64;
            }
            case "avg": 
            case "sum": {
                return TSDataType.DOUBLE;
            }
        }
        return null;
    }

    public static boolean isConsistentWithScanOrder(TAggregationType aggregationFunction, Ordering scanOrder) {
        boolean ascending = scanOrder == Ordering.ASC;
        switch (aggregationFunction) {
            case MIN_TIME: 
            case FIRST_VALUE: {
                return ascending;
            }
            case MAX_TIME: 
            case LAST_VALUE: {
                return !ascending;
            }
            case SUM: 
            case MIN_VALUE: 
            case MAX_VALUE: 
            case EXTREME: 
            case COUNT: 
            case AVG: {
                return true;
            }
        }
        throw new IllegalArgumentException(String.format("Invalid Aggregation function: %s", aggregationFunction));
    }

    public static void checkDataTypeWithEncoding(TSDataType dataType, TSEncoding encoding) throws MetadataException {
        if (!schemaChecker.get(dataType).contains(encoding)) {
            throw new MetadataException(String.format("encoding %s does not support %s", encoding, dataType), true);
        }
    }

    public static List<TAggregationType> splitPartialAggregation(TAggregationType aggregationType) {
        switch (aggregationType) {
            case FIRST_VALUE: {
                return Collections.singletonList(TAggregationType.MIN_TIME);
            }
            case LAST_VALUE: {
                return Collections.singletonList(TAggregationType.MAX_TIME);
            }
            case AVG: {
                return Arrays.asList(TAggregationType.COUNT, TAggregationType.SUM);
            }
            case MIN_TIME: 
            case MAX_TIME: 
            case SUM: 
            case MIN_VALUE: 
            case MAX_VALUE: 
            case EXTREME: 
            case COUNT: 
            case COUNT_IF: {
                return Collections.emptyList();
            }
        }
        throw new IllegalArgumentException(String.format("Invalid Aggregation function: %s", aggregationType));
    }

    static {
        HashSet<TSEncoding> booleanSet = new HashSet<TSEncoding>();
        booleanSet.add(TSEncoding.PLAIN);
        booleanSet.add(TSEncoding.RLE);
        schemaChecker.put(TSDataType.BOOLEAN, booleanSet);
        HashSet<TSEncoding> intSet = new HashSet<TSEncoding>();
        intSet.add(TSEncoding.PLAIN);
        intSet.add(TSEncoding.RLE);
        intSet.add(TSEncoding.TS_2DIFF);
        intSet.add(TSEncoding.GORILLA);
        intSet.add(TSEncoding.ZIGZAG);
        intSet.add(TSEncoding.FREQ);
        intSet.add(TSEncoding.CHIMP);
        schemaChecker.put(TSDataType.INT32, intSet);
        schemaChecker.put(TSDataType.INT64, intSet);
        HashSet<TSEncoding> floatSet = new HashSet<TSEncoding>();
        floatSet.add(TSEncoding.PLAIN);
        floatSet.add(TSEncoding.RLE);
        floatSet.add(TSEncoding.TS_2DIFF);
        floatSet.add(TSEncoding.GORILLA_V1);
        floatSet.add(TSEncoding.GORILLA);
        floatSet.add(TSEncoding.FREQ);
        floatSet.add(TSEncoding.CHIMP);
        schemaChecker.put(TSDataType.FLOAT, floatSet);
        schemaChecker.put(TSDataType.DOUBLE, floatSet);
        HashSet<TSEncoding> textSet = new HashSet<TSEncoding>();
        textSet.add(TSEncoding.PLAIN);
        textSet.add(TSEncoding.DICTIONARY);
        schemaChecker.put(TSDataType.TEXT, textSet);
    }
}

