/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import java.util.List;
import org.apache.iotdb.db.engine.modification.Deletion;
import org.apache.iotdb.db.engine.modification.Modification;
import org.apache.iotdb.tsfile.file.metadata.AlignedChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;
import org.apache.iotdb.tsfile.read.common.TimeRange;

public class ModificationUtils {
    private ModificationUtils() {
    }

    public static void modifyChunkMetaData(List<? extends IChunkMetadata> chunkMetaData, List<Modification> modifications) {
        for (IChunkMetadata iChunkMetadata : chunkMetaData) {
            for (Modification modification : modifications) {
                if (iChunkMetadata.isFromOldTsFile()) {
                    if (modification.getFileOffset() <= iChunkMetadata.getVersion()) continue;
                    ModificationUtils.doModifyChunkMetaData(modification, iChunkMetadata);
                    continue;
                }
                if (modification.getFileOffset() <= iChunkMetadata.getOffsetOfChunkHeader()) continue;
                ModificationUtils.doModifyChunkMetaData(modification, iChunkMetadata);
            }
        }
        chunkMetaData.removeIf(metaData -> {
            if (metaData.getDeleteIntervalList() != null) {
                for (TimeRange range : metaData.getDeleteIntervalList()) {
                    if (range.contains(metaData.getStartTime(), metaData.getEndTime())) {
                        return true;
                    }
                    if (!range.overlaps(new TimeRange(metaData.getStartTime(), metaData.getEndTime()))) continue;
                    metaData.setModified(true);
                }
            }
            return false;
        });
    }

    public static void modifyAlignedChunkMetaData(List<AlignedChunkMetadata> chunkMetaData, List<List<Modification>> modifications) {
        for (AlignedChunkMetadata metaData : chunkMetaData) {
            List valueChunkMetadataList = metaData.getValueChunkMetadataList();
            for (int i = 0; i < valueChunkMetadataList.size(); ++i) {
                IChunkMetadata v = (IChunkMetadata)valueChunkMetadataList.get(i);
                if (v == null) continue;
                List<Modification> modificationList = modifications.get(i);
                for (Modification modification : modificationList) {
                    if (modification.getFileOffset() <= v.getOffsetOfChunkHeader()) continue;
                    ModificationUtils.doModifyChunkMetaData(modification, v);
                }
            }
        }
        chunkMetaData.removeIf(alignedChunkMetadata -> {
            boolean removed = true;
            boolean modified = false;
            List valueChunkMetadataList = alignedChunkMetadata.getValueChunkMetadataList();
            for (int i = 0; i < valueChunkMetadataList.size(); ++i) {
                IChunkMetadata valueChunkMetadata = (IChunkMetadata)valueChunkMetadataList.get(i);
                if (valueChunkMetadata == null) continue;
                boolean currentRemoved = false;
                if (valueChunkMetadata.getDeleteIntervalList() != null) {
                    for (TimeRange range : valueChunkMetadata.getDeleteIntervalList()) {
                        if (range.contains(valueChunkMetadata.getStartTime(), valueChunkMetadata.getEndTime())) {
                            valueChunkMetadataList.set(i, null);
                            currentRemoved = true;
                            break;
                        }
                        if (!range.overlaps(new TimeRange(valueChunkMetadata.getStartTime(), valueChunkMetadata.getEndTime()))) continue;
                        valueChunkMetadata.setModified(true);
                        modified = true;
                    }
                }
                if (currentRemoved) continue;
                removed = false;
            }
            alignedChunkMetadata.setModified(modified);
            return removed;
        });
    }

    private static void doModifyChunkMetaData(Modification modification, IChunkMetadata metaData) {
        if (modification instanceof Deletion) {
            Deletion deletion = (Deletion)modification;
            metaData.insertIntoSortedDeletions(deletion.getTimeRange());
        }
    }
}

