/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.tools.validate;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.encoding.decoder.Decoder;
import org.apache.iotdb.tsfile.file.MetaMarker;
import org.apache.iotdb.tsfile.file.header.ChunkGroupHeader;
import org.apache.iotdb.tsfile.file.header.ChunkHeader;
import org.apache.iotdb.tsfile.file.header.PageHeader;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.reader.page.PageReader;
import org.apache.iotdb.tsfile.read.reader.page.TimePageReader;
import org.apache.iotdb.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsFileValidationTool {
    private static boolean printDetails = false;
    private static boolean printToFile = false;
    private static String outFilePath = "TsFile_validation_view.txt";
    private static PrintWriter pw = null;
    private static final Logger logger = LoggerFactory.getLogger(TsFileValidationTool.class);
    private static final List<File> seqDataDirList = new ArrayList<File>();
    private static final List<File> fileList = new ArrayList<File>();
    public static int badFileNum = 0;
    private static final Map<String, Pair<String, long[]>> measurementLastTime = new HashMap<String, Pair<String, long[]>>();
    private static final Map<String, Pair<String, Long>> deviceEndTime = new HashMap<String, Pair<String, Long>>();
    private static final Map<String, Boolean> isBadFileMap = new HashMap<String, Boolean>();

    public static void main(String[] args) throws IOException {
        if (!TsFileValidationTool.checkArgs(args)) {
            System.exit(1);
        }
        if (printToFile) {
            pw = new PrintWriter(new FileWriter(outFilePath));
        }
        if (printDetails) {
            TsFileValidationTool.printBoth("Start checking seq files ...");
        }
        for (File f : fileList) {
            TsFileValidationTool.findUncorrectFiles(Collections.singletonList(f));
        }
        for (File seqDataDir : seqDataDirList) {
            if (!TsFileValidationTool.checkIsDirectory(seqDataDir)) continue;
            File[] sgDirs = seqDataDir.listFiles();
            for (File sgDir : Objects.requireNonNull(sgDirs)) {
                if (!TsFileValidationTool.checkIsDirectory(sgDir)) continue;
                if (printDetails) {
                    TsFileValidationTool.printBoth("- Check files in database: " + sgDir.getAbsolutePath());
                }
                File[] dataRegionDirs = sgDir.listFiles();
                for (File dataRegionDir : Objects.requireNonNull(dataRegionDirs)) {
                    if (!TsFileValidationTool.checkIsDirectory(dataRegionDir)) continue;
                    List timePartitionDirs = Arrays.asList(Objects.requireNonNull(dataRegionDir.listFiles())).stream().filter(file -> Pattern.compile("[0-9]*").matcher(file.getName()).matches()).collect(Collectors.toList());
                    timePartitionDirs.sort((f1, f2) -> Long.compareUnsigned(Long.parseLong(f1.getName()), Long.parseLong(f2.getName())));
                    for (File timePartitionDir : Objects.requireNonNull(timePartitionDirs)) {
                        if (!TsFileValidationTool.checkIsDirectory(timePartitionDir)) continue;
                        List<File> tsFiles = Arrays.asList(Objects.requireNonNull(timePartitionDir.listFiles(file -> file.getName().endsWith(".tsfile"))));
                        tsFiles.sort((f1, f2) -> {
                            int timeDiff = Long.compareUnsigned(Long.parseLong(f1.getName().split("-")[0]), Long.parseLong(f2.getName().split("-")[0]));
                            return timeDiff == 0 ? Long.compareUnsigned(Long.parseLong(f1.getName().split("-")[1]), Long.parseLong(f2.getName().split("-")[1])) : timeDiff;
                        });
                        TsFileValidationTool.findUncorrectFiles(tsFiles);
                    }
                    TsFileValidationTool.clearMap(false);
                }
            }
        }
        if (printDetails) {
            TsFileValidationTool.printBoth("Finish checking successfully, totally find " + badFileNum + " bad files.");
        }
        if (printToFile) {
            pw.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void findUncorrectFiles(List<File> tsFiles) {
        for (File tsFile : tsFiles) {
            ArrayList<String> previousBadFileMsgs = new ArrayList<String>();
            try {
                TsFileResource resource = new TsFileResource(tsFile);
                if (!new File(tsFile.getAbsolutePath() + ".resource").exists()) {
                    logger.warn("{} does not exist ,skip it.", (Object)(tsFile.getAbsolutePath() + ".resource"));
                    continue;
                }
                resource.deserialize();
                isBadFileMap.put(tsFile.getName(), false);
                try (TsFileSequenceReader reader = new TsFileSequenceReader(tsFile.getAbsolutePath());){
                    byte marker;
                    HashMap<String, Boolean> hasCheckedDeviceOverlap = new HashMap<String, Boolean>();
                    reader.position((long)"TsFile".getBytes().length + 1L);
                    String deviceID = "";
                    HashMap<String, boolean[]> hasMeasurementPrintedDetails = new HashMap<String, boolean[]>();
                    HashMap<String, Long> lashChunkEndTime = new HashMap<String, Long>();
                    block17: while ((marker = reader.readMarker()) != 2) {
                        switch (marker) {
                            case -127: 
                            case -123: 
                            case 1: 
                            case 5: 
                            case 65: 
                            case 69: {
                                PageHeader pageHeader;
                                ChunkHeader header = reader.readChunkHeader(marker);
                                if (header.getDataSize() == 0) continue block17;
                                long currentChunkEndTime = Long.MIN_VALUE;
                                String measurementID = deviceID + '.' + header.getMeasurementID();
                                hasMeasurementPrintedDetails.computeIfAbsent(measurementID, k -> new boolean[4]);
                                measurementLastTime.computeIfAbsent(measurementID, k -> {
                                    long[] arr = new long[2];
                                    Arrays.fill(arr, Long.MIN_VALUE);
                                    return new Pair((Object)"", (Object)arr);
                                });
                                Decoder defaultTimeDecoder = Decoder.getDecoderByType((TSEncoding)TSEncoding.valueOf((String)TSFileDescriptor.getInstance().getConfig().getTimeEncoder()), (TSDataType)TSDataType.INT64);
                                Decoder valueDecoder = Decoder.getDecoderByType((TSEncoding)header.getEncodingType(), (TSDataType)header.getDataType());
                                long lastPageEndTime = Long.MIN_VALUE;
                                for (int dataSize = header.getDataSize(); dataSize > 0; dataSize -= pageHeader.getSerializedPageSize()) {
                                    valueDecoder.reset();
                                    pageHeader = reader.readPageHeader(header.getDataType(), (header.getChunkType() & 0x3F) == 1);
                                    ByteBuffer pageData = reader.readPage(pageHeader, header.getCompressionType());
                                    long currentPageEndTime = Long.MIN_VALUE;
                                    if ((header.getChunkType() & 0xFFFFFF80) == -128) {
                                        TimePageReader timePageReader = new TimePageReader(pageHeader, pageData, defaultTimeDecoder);
                                        long[] timeBatch = timePageReader.getNextTimeBatch();
                                        for (int i = 0; i < timeBatch.length; ++i) {
                                            long timestamp = timeBatch[i];
                                            if (timestamp <= ((long[])TsFileValidationTool.measurementLastTime.get((Object)measurementID).right)[0]) {
                                                String lastBadFile;
                                                if (timestamp <= ((long[])TsFileValidationTool.measurementLastTime.get((Object)measurementID).right)[1] && !isBadFileMap.get(lastBadFile = (String)TsFileValidationTool.measurementLastTime.get((Object)measurementID).left).booleanValue()) {
                                                    if (printDetails) {
                                                        previousBadFileMsgs.add("-- Find the bad file " + tsFile.getParentFile().getAbsolutePath() + File.separator + lastBadFile + ", overlap with later files.");
                                                    } else {
                                                        previousBadFileMsgs.add(tsFile.getParentFile().getAbsolutePath() + File.separator + lastBadFile);
                                                    }
                                                    isBadFileMap.put(lastBadFile, true);
                                                    ++badFileNum;
                                                }
                                                if (!isBadFileMap.get(tsFile.getName()).booleanValue()) {
                                                    if (printDetails) {
                                                        TsFileValidationTool.printBoth("-- Find the bad file " + tsFile.getAbsolutePath());
                                                    } else {
                                                        TsFileValidationTool.printBoth(tsFile.getAbsolutePath());
                                                    }
                                                    isBadFileMap.put(tsFile.getName(), true);
                                                    ++badFileNum;
                                                }
                                                if (!printDetails) continue;
                                                if (timestamp <= ((long[])TsFileValidationTool.measurementLastTime.get((Object)measurementID).right)[1]) {
                                                    if (((boolean[])hasMeasurementPrintedDetails.get(measurementID))[0]) continue;
                                                    TsFileValidationTool.printBoth("-------- Timeseries " + measurementID + " overlap between files, with previous file " + (String)TsFileValidationTool.measurementLastTime.get((Object)measurementID).left);
                                                    ((boolean[])hasMeasurementPrintedDetails.get((Object)measurementID))[0] = true;
                                                    continue;
                                                }
                                                if (timestamp <= lashChunkEndTime.getOrDefault(measurementID, Long.MIN_VALUE)) {
                                                    if (((boolean[])hasMeasurementPrintedDetails.get(measurementID))[1]) continue;
                                                    TsFileValidationTool.printBoth("-------- Timeseries " + measurementID + " overlap between chunks");
                                                    ((boolean[])hasMeasurementPrintedDetails.get((Object)measurementID))[1] = true;
                                                    continue;
                                                }
                                                if (timestamp <= lastPageEndTime) {
                                                    if (((boolean[])hasMeasurementPrintedDetails.get(measurementID))[2]) continue;
                                                    TsFileValidationTool.printBoth("-------- Timeseries " + measurementID + " overlap between pages");
                                                    ((boolean[])hasMeasurementPrintedDetails.get((Object)measurementID))[2] = true;
                                                    continue;
                                                }
                                                if (((boolean[])hasMeasurementPrintedDetails.get(measurementID))[3]) continue;
                                                TsFileValidationTool.printBoth("-------- Timeseries " + measurementID + " overlap within one page");
                                                ((boolean[])hasMeasurementPrintedDetails.get((Object)measurementID))[3] = true;
                                                continue;
                                            }
                                            ((long[])TsFileValidationTool.measurementLastTime.get((Object)measurementID).right)[0] = timestamp;
                                            currentPageEndTime = timestamp;
                                            currentChunkEndTime = timestamp;
                                        }
                                    } else if ((header.getChunkType() & 0x40) != 64) {
                                        PageReader pageReader = new PageReader(pageData, header.getDataType(), valueDecoder, defaultTimeDecoder, null);
                                        BatchData batchData = pageReader.getAllSatisfiedPageData();
                                        while (batchData.hasCurrent()) {
                                            long timestamp = batchData.currentTime();
                                            if (timestamp <= ((long[])TsFileValidationTool.measurementLastTime.get((Object)measurementID).right)[0]) {
                                                if (timestamp <= ((long[])TsFileValidationTool.measurementLastTime.get((Object)measurementID).right)[1] && !isBadFileMap.get(TsFileValidationTool.measurementLastTime.get((Object)measurementID).left).booleanValue()) {
                                                    if (printDetails) {
                                                        previousBadFileMsgs.add("-- Find the bad file " + tsFile.getParentFile().getAbsolutePath() + File.separator + (String)TsFileValidationTool.measurementLastTime.get((Object)measurementID).left + ", overlap with later files.");
                                                    } else {
                                                        previousBadFileMsgs.add(tsFile.getParentFile().getAbsolutePath() + File.separator + (String)TsFileValidationTool.measurementLastTime.get((Object)measurementID).left);
                                                    }
                                                    ++badFileNum;
                                                    isBadFileMap.put((String)TsFileValidationTool.measurementLastTime.get((Object)measurementID).left, true);
                                                }
                                                if (!isBadFileMap.get(tsFile.getName()).booleanValue()) {
                                                    if (printDetails) {
                                                        TsFileValidationTool.printBoth("-- Find the bad file " + tsFile.getAbsolutePath());
                                                    } else {
                                                        TsFileValidationTool.printBoth(tsFile.getAbsolutePath());
                                                    }
                                                    isBadFileMap.put(tsFile.getName(), true);
                                                    ++badFileNum;
                                                }
                                                if (printDetails) {
                                                    if (timestamp <= ((long[])TsFileValidationTool.measurementLastTime.get((Object)measurementID).right)[1]) {
                                                        if (!((boolean[])hasMeasurementPrintedDetails.get(measurementID))[0]) {
                                                            TsFileValidationTool.printBoth("-------- Timeseries " + measurementID + " overlap between files, with previous file " + (String)TsFileValidationTool.measurementLastTime.get((Object)measurementID).left);
                                                            ((boolean[])hasMeasurementPrintedDetails.get((Object)measurementID))[0] = true;
                                                        }
                                                    } else if (timestamp <= lashChunkEndTime.getOrDefault(measurementID, Long.MIN_VALUE)) {
                                                        if (!((boolean[])hasMeasurementPrintedDetails.get(measurementID))[1]) {
                                                            TsFileValidationTool.printBoth("-------- Timeseries " + measurementID + " overlap between chunks");
                                                            ((boolean[])hasMeasurementPrintedDetails.get((Object)measurementID))[1] = true;
                                                        }
                                                    } else if (timestamp <= lastPageEndTime) {
                                                        if (!((boolean[])hasMeasurementPrintedDetails.get(measurementID))[2]) {
                                                            TsFileValidationTool.printBoth("-------- Timeseries " + measurementID + " overlap between pages");
                                                            ((boolean[])hasMeasurementPrintedDetails.get((Object)measurementID))[2] = true;
                                                        }
                                                    } else if (!((boolean[])hasMeasurementPrintedDetails.get(measurementID))[3]) {
                                                        TsFileValidationTool.printBoth("-------- Timeseries " + measurementID + " overlap within one page");
                                                        ((boolean[])hasMeasurementPrintedDetails.get((Object)measurementID))[3] = true;
                                                    }
                                                }
                                            } else {
                                                ((long[])TsFileValidationTool.measurementLastTime.get((Object)measurementID).right)[0] = timestamp;
                                                currentPageEndTime = timestamp;
                                                currentChunkEndTime = timestamp;
                                            }
                                            batchData.next();
                                        }
                                    }
                                    lastPageEndTime = Math.max(lastPageEndTime, currentPageEndTime);
                                }
                                lashChunkEndTime.put(measurementID, Math.max(lashChunkEndTime.getOrDefault(measurementID, Long.MIN_VALUE), currentChunkEndTime));
                                continue block17;
                            }
                            case 0: {
                                ChunkGroupHeader chunkGroupHeader;
                                if (!deviceID.equals("") && resource.getEndTime(deviceID) > (Long)TsFileValidationTool.deviceEndTime.computeIfAbsent((String)deviceID, (Function<String, Pair>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$findUncorrectFiles$6(java.lang.String ), (Ljava/lang/String;)Lorg/apache/iotdb/tsfile/utils/Pair;)()).right) {
                                    TsFileValidationTool.deviceEndTime.get((Object)deviceID).left = tsFile.getName();
                                    TsFileValidationTool.deviceEndTime.get((Object)deviceID).right = resource.getEndTime(deviceID);
                                }
                                if (!hasCheckedDeviceOverlap.getOrDefault(deviceID = (chunkGroupHeader = reader.readChunkGroupHeader()).getDeviceID(), false).booleanValue() && resource.getStartTime(deviceID) <= (Long)TsFileValidationTool.deviceEndTime.computeIfAbsent((String)deviceID, (Function<String, Pair>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$findUncorrectFiles$7(java.lang.String ), (Ljava/lang/String;)Lorg/apache/iotdb/tsfile/utils/Pair;)()).right) {
                                    if (!isBadFileMap.get(TsFileValidationTool.deviceEndTime.get((Object)deviceID).left).booleanValue()) {
                                        if (printDetails) {
                                            previousBadFileMsgs.add("-- Find the bad file " + tsFile.getParentFile().getAbsolutePath() + File.separator + (String)TsFileValidationTool.deviceEndTime.get((Object)deviceID).left + ", overlap with later files.");
                                        } else {
                                            previousBadFileMsgs.add(tsFile.getParentFile().getAbsolutePath() + File.separator + (String)TsFileValidationTool.deviceEndTime.get((Object)deviceID).left);
                                        }
                                        isBadFileMap.put((String)TsFileValidationTool.deviceEndTime.get((Object)deviceID).left, true);
                                        ++badFileNum;
                                    }
                                    if (!isBadFileMap.get(tsFile.getName()).booleanValue()) {
                                        if (printDetails) {
                                            TsFileValidationTool.printBoth("-- Find the bad file " + tsFile.getAbsolutePath());
                                        } else {
                                            TsFileValidationTool.printBoth(tsFile.getAbsolutePath());
                                        }
                                        isBadFileMap.put(tsFile.getName(), true);
                                        ++badFileNum;
                                    }
                                    if (printDetails) {
                                        TsFileValidationTool.printBoth("---- Device " + deviceID + " overlap between files, with previous file " + (String)TsFileValidationTool.deviceEndTime.get((Object)deviceID).left);
                                    }
                                }
                                hasCheckedDeviceOverlap.put(deviceID, true);
                                continue block17;
                            }
                            case 4: {
                                reader.readPlanIndex();
                                continue block17;
                            }
                        }
                        MetaMarker.handleUnexpectedMarker((byte)marker);
                    }
                    for (Map.Entry entry : lashChunkEndTime.entrySet()) {
                        if (((long[])TsFileValidationTool.measurementLastTime.get(entry.getKey()).right)[1] > (Long)entry.getValue()) continue;
                        ((long[])TsFileValidationTool.measurementLastTime.get(entry.getKey()).right)[1] = (Long)entry.getValue();
                        TsFileValidationTool.measurementLastTime.get(entry.getKey()).left = tsFile.getName();
                    }
                }
            }
            catch (Throwable e) {
                logger.error("Meet errors in reading file {} , skip it.", (Object)tsFile.getAbsolutePath(), (Object)e);
                if (!isBadFileMap.get(tsFile.getName()).booleanValue()) {
                    if (printDetails) {
                        TsFileValidationTool.printBoth("-- Meet errors in reading file " + tsFile.getAbsolutePath() + ", tsfile may be corrupted.");
                    } else {
                        TsFileValidationTool.printBoth(tsFile.getAbsolutePath());
                    }
                    isBadFileMap.put(tsFile.getName(), true);
                    ++badFileNum;
                }
            }
            finally {
                for (String msg : previousBadFileMsgs) {
                    TsFileValidationTool.printBoth(msg);
                }
            }
        }
    }

    private static boolean checkArgs(String[] args) {
        if (args.length < 1) {
            System.out.println("Please input correct param, which is [path of data dir] [-pd = print details or not] [-f = path of outFile]. Eg: xxx/iotdb/data/data -pd=true -f=xxx/TsFile_validation_view.txt");
            return false;
        }
        for (String arg : args) {
            if (arg.startsWith("-pd")) {
                printDetails = Boolean.parseBoolean(arg.split("=")[1]);
                continue;
            }
            if (arg.startsWith("-f")) {
                printToFile = true;
                outFilePath = arg.split("=")[1];
                continue;
            }
            File f = new File(arg);
            if (f.isDirectory() && Objects.requireNonNull(f.list((dir, name) -> name.equals("sequence") || name.equals("unsequence"))).length == 2) {
                File seqDataDir = new File(f, "sequence");
                seqDataDirList.add(seqDataDir);
                continue;
            }
            if (arg.endsWith(".tsfile") && f.isFile()) {
                fileList.add(f);
                continue;
            }
            System.out.println(arg + " is not a correct data directory or tsfile of IOTDB.");
            return false;
        }
        if (seqDataDirList.isEmpty() && fileList.isEmpty()) {
            System.out.println("Please input correct param, which is [path of data dir] [-pd = print details or not] [-f = path of outFile]. Eg: xxx/iotdb/data/data -pd=true -f=xxx/TsFile_validation_view.txt");
            return false;
        }
        return true;
    }

    public static void clearMap(boolean resetBadFileNum) {
        if (resetBadFileNum) {
            badFileNum = 0;
        }
        measurementLastTime.clear();
        deviceEndTime.clear();
        isBadFileMap.clear();
    }

    private static boolean checkIsDirectory(File dir) {
        boolean res = true;
        if (!dir.isDirectory()) {
            logger.error("{} is not a directory or does not exist, skip it.", (Object)dir.getAbsolutePath());
            res = false;
        }
        return res;
    }

    private static void printBoth(String msg) {
        System.out.println(msg);
        if (printToFile) {
            pw.println(msg);
        }
    }

    private static /* synthetic */ Pair lambda$findUncorrectFiles$7(String k) {
        return new Pair((Object)"", (Object)Long.MIN_VALUE);
    }

    private static /* synthetic */ Pair lambda$findUncorrectFiles$6(String k) {
        return new Pair((Object)"", (Object)Long.MIN_VALUE);
    }
}

