/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.reader.chunk.metadata;

import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.commons.path.AlignedPath;
import org.apache.iotdb.db.engine.modification.Modification;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.mpp.metric.QueryMetricsManager;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.reader.chunk.DiskAlignedChunkLoader;
import org.apache.iotdb.db.utils.ModificationUtils;
import org.apache.iotdb.tsfile.file.metadata.AlignedTimeSeriesMetadata;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.ITimeSeriesMetadata;
import org.apache.iotdb.tsfile.read.controller.IChunkLoader;
import org.apache.iotdb.tsfile.read.controller.IChunkMetadataLoader;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiskAlignedChunkMetadataLoader
implements IChunkMetadataLoader {
    private final TsFileResource resource;
    private final AlignedPath seriesPath;
    private final QueryContext context;
    private final Filter filter;
    private static final Logger DEBUG_LOGGER = LoggerFactory.getLogger((String)"QUERY_DEBUG");
    private static final QueryMetricsManager QUERY_METRICS = QueryMetricsManager.getInstance();

    public DiskAlignedChunkMetadataLoader(TsFileResource resource, AlignedPath seriesPath, QueryContext context, Filter filter) {
        this.resource = resource;
        this.seriesPath = seriesPath;
        this.context = context;
        this.filter = filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IChunkMetadata> loadChunkMetadataList(ITimeSeriesMetadata timeSeriesMetadata) {
        long t1 = System.nanoTime();
        try {
            List alignedChunkMetadataList = ((AlignedTimeSeriesMetadata)timeSeriesMetadata).getCopiedChunkMetadataList();
            long t2 = System.nanoTime();
            List<List<Modification>> pathModifications = this.context.getPathModifications(this.resource.getModFile(), this.seriesPath);
            if (this.context.isDebug()) {
                DEBUG_LOGGER.info("Modifications size is {} for file Path: {} ", (Object)pathModifications.size(), (Object)this.resource.getTsFilePath());
                pathModifications.forEach(c -> DEBUG_LOGGER.info(c.toString()));
            }
            ModificationUtils.modifyAlignedChunkMetaData(alignedChunkMetadataList, pathModifications);
            if (this.context.isDebug()) {
                DEBUG_LOGGER.info("After modification Chunk meta data list is: ");
                alignedChunkMetadataList.forEach(c -> DEBUG_LOGGER.info(c.toString()));
            }
            QUERY_METRICS.recordSeriesScanCost("chunk_metadata_modification_aligned_disk", System.nanoTime() - t2);
            long t3 = System.nanoTime();
            alignedChunkMetadataList.removeIf(alignedChunkMetaData -> this.filter != null && !this.filter.satisfyStartEndTime(alignedChunkMetaData.getStartTime(), alignedChunkMetaData.getEndTime()) || alignedChunkMetaData.getStartTime() > alignedChunkMetaData.getEndTime());
            QUERY_METRICS.recordSeriesScanCost("chunk_metadata_filter_aligned_disk", System.nanoTime() - t3);
            alignedChunkMetadataList.forEach(chunkMetadata -> {
                if (chunkMetadata.needSetChunkLoader()) {
                    chunkMetadata.setFilePath(this.resource.getTsFilePath());
                    chunkMetadata.setClosed(this.resource.isClosed());
                    chunkMetadata.setChunkLoader((IChunkLoader)new DiskAlignedChunkLoader(this.context.isDebug()));
                }
            });
            if (this.context.isDebug()) {
                DEBUG_LOGGER.info("After removed by filter Chunk meta data list is: ");
                alignedChunkMetadataList.forEach(c -> DEBUG_LOGGER.info(c.toString()));
            }
            ArrayList<IChunkMetadata> arrayList = new ArrayList<IChunkMetadata>(alignedChunkMetadataList);
            return arrayList;
        }
        finally {
            QUERY_METRICS.recordSeriesScanCost("load_chunk_metadata_list_aligned_disk", System.nanoTime() - t1);
        }
    }
}

