/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.influxdb.function.aggregator;

import java.util.List;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.protocol.influxdb.function.InfluxFunctionValue;
import org.apache.iotdb.db.protocol.influxdb.function.aggregator.InfluxAggregator;

public class InfluxCountFunction
extends InfluxAggregator {
    private int countNum = 0;

    public InfluxCountFunction(List<Expression> expressionList) {
        super(expressionList);
    }

    @Override
    public InfluxFunctionValue calculateBruteForce() {
        return new InfluxFunctionValue(this.countNum, 0L);
    }

    @Override
    public InfluxFunctionValue calculateByIoTDBFunc() {
        return this.calculateBruteForce();
    }

    @Override
    public String getFunctionName() {
        return "count";
    }

    @Override
    public void updateValueBruteForce(InfluxFunctionValue functionValue) {
        ++this.countNum;
    }

    @Override
    public void updateValueIoTDBFunc(InfluxFunctionValue ... functionValues) {
        this.countNum = (int)((long)this.countNum + (Long)functionValues[0].getValue());
    }
}

