/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.transformation.dag.column.unary;

import java.util.regex.Pattern;
import org.apache.iotdb.db.mpp.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.db.mpp.transformation.dag.column.unary.UnaryColumnTransformer;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.tsfile.read.common.type.Type;
import org.apache.iotdb.tsfile.read.common.type.TypeEnum;

public class RegularColumnTransformer
extends UnaryColumnTransformer {
    private final Pattern pattern;

    public RegularColumnTransformer(Type returnType, ColumnTransformer childColumnTransformer, Pattern pattern) {
        super(returnType, childColumnTransformer);
        this.pattern = pattern;
    }

    @Override
    protected void doTransform(Column column, ColumnBuilder columnBuilder) {
        int n = column.getPositionCount();
        for (int i = 0; i < n; ++i) {
            if (!column.isNull(i)) {
                this.returnType.writeBoolean(columnBuilder, this.pattern.matcher(this.childColumnTransformer.getType().getBinary(column, i).getStringValue()).find());
                continue;
            }
            columnBuilder.appendNull();
        }
    }

    @Override
    protected void checkType() {
        if (!this.childColumnTransformer.typeEquals(TypeEnum.BINARY)) {
            throw new UnsupportedOperationException("Unsupported Type: " + this.childColumnTransformer.getType().getTypeEnum());
        }
    }
}

