/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.scheduler;

import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.commons.service.metric.enums.PerformanceOverviewMetrics;
import org.apache.iotdb.mpp.rpc.thrift.TSendBatchPlanNodeResp;
import org.apache.iotdb.mpp.rpc.thrift.TSendSinglePlanNodeResp;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.async.AsyncMethodCallback;

public class AsyncSendPlanNodeHandler
implements AsyncMethodCallback<TSendBatchPlanNodeResp> {
    private final List<Integer> instanceIds;
    private final AtomicLong pendingNumber;
    private final Map<Integer, TSendSinglePlanNodeResp> instanceId2RespMap;
    private final long sendTime;
    private static final PerformanceOverviewMetrics PERFORMANCE_OVERVIEW_METRICS = PerformanceOverviewMetrics.getInstance();

    public AsyncSendPlanNodeHandler(List<Integer> instanceIds, AtomicLong pendingNumber, Map<Integer, TSendSinglePlanNodeResp> instanceId2RespMap, long sendTime) {
        this.instanceIds = instanceIds;
        this.pendingNumber = pendingNumber;
        this.instanceId2RespMap = instanceId2RespMap;
        this.sendTime = sendTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onComplete(TSendBatchPlanNodeResp sendBatchPlanNodeResp) {
        for (int i = 0; i < sendBatchPlanNodeResp.getResponses().size(); ++i) {
            this.instanceId2RespMap.put(this.instanceIds.get(i), (TSendSinglePlanNodeResp)sendBatchPlanNodeResp.getResponses().get(i));
        }
        if (this.pendingNumber.decrementAndGet() == 0L) {
            PERFORMANCE_OVERVIEW_METRICS.recordScheduleRemoteCost(System.nanoTime() - this.sendTime);
            AtomicLong atomicLong = this.pendingNumber;
            synchronized (atomicLong) {
                this.pendingNumber.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onError(Exception e) {
        TSendSinglePlanNodeResp resp = new TSendSinglePlanNodeResp();
        String errorMsg = String.format("Fail to send plan node, exception message: %s", e);
        resp.setAccepted(false);
        resp.setMessage(errorMsg);
        resp.setStatus(RpcUtils.getStatus((int)TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode(), (String)errorMsg));
        this.instanceIds.forEach(instanceId -> this.instanceId2RespMap.put((Integer)instanceId, resp));
        if (this.pendingNumber.decrementAndGet() == 0L) {
            PERFORMANCE_OVERVIEW_METRICS.recordScheduleRemoteCost(System.nanoTime() - this.sendTime);
            AtomicLong atomicLong = this.pendingNumber;
            synchronized (atomicLong) {
                this.pendingNumber.notifyAll();
            }
        }
    }
}

