/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.planner;

import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.schemaregion.ISchemaRegion;
import org.apache.iotdb.db.mpp.exception.MemoryNotEnoughException;
import org.apache.iotdb.db.mpp.execution.driver.DataDriverContext;
import org.apache.iotdb.db.mpp.execution.fragment.FragmentInstanceContext;
import org.apache.iotdb.db.mpp.execution.fragment.FragmentInstanceStateMachine;
import org.apache.iotdb.db.mpp.execution.operator.Operator;
import org.apache.iotdb.db.mpp.plan.analyze.TypeProvider;
import org.apache.iotdb.db.mpp.plan.planner.LocalExecutionPlanContext;
import org.apache.iotdb.db.mpp.plan.planner.OperatorTreeGenerator;
import org.apache.iotdb.db.mpp.plan.planner.PipelineDriverFactory;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.utils.SetThreadName;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalExecutionPlanner {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalExecutionPlanner.class);
    private long freeMemoryForOperators = IoTDBDescriptor.getInstance().getConfig().getAllocateMemoryForOperators();

    public static LocalExecutionPlanner getInstance() {
        return InstanceHolder.INSTANCE;
    }

    public List<PipelineDriverFactory> plan(PlanNode plan, TypeProvider types, FragmentInstanceContext instanceContext) throws MemoryNotEnoughException, QueryProcessException {
        LocalExecutionPlanContext context = new LocalExecutionPlanContext(types, instanceContext);
        Operator root = plan.accept(new OperatorTreeGenerator(), context);
        this.checkMemory(root, instanceContext.getStateMachine());
        context.addPipelineDriverFactory(root, context.getDriverContext());
        instanceContext.setSourcePaths(this.collectSourcePaths(context));
        context.setMaxBytesOneHandleCanReserve();
        return context.getPipelineDriverFactories();
    }

    public List<PipelineDriverFactory> plan(PlanNode plan, FragmentInstanceContext instanceContext, ISchemaRegion schemaRegion) throws MemoryNotEnoughException {
        LocalExecutionPlanContext context = new LocalExecutionPlanContext(instanceContext, schemaRegion);
        Operator root = plan.accept(new OperatorTreeGenerator(), context);
        this.checkMemory(root, instanceContext.getStateMachine());
        context.addPipelineDriverFactory(root, context.getDriverContext());
        context.setMaxBytesOneHandleCanReserve();
        return context.getPipelineDriverFactories();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkMemory(Operator root, FragmentInstanceStateMachine stateMachine) throws MemoryNotEnoughException {
        if (!IoTDBDescriptor.getInstance().getConfig().isEnableQueryMemoryEstimation()) {
            return;
        }
        long estimatedMemorySize = root.calculateMaxPeekMemory();
        LocalExecutionPlanner localExecutionPlanner = this;
        synchronized (localExecutionPlanner) {
            if (estimatedMemorySize > this.freeMemoryForOperators) {
                throw new MemoryNotEnoughException(String.format("There is not enough memory to execute current fragment instance, current remaining free memory is %d, estimated memory usage for current fragment instance is %d", this.freeMemoryForOperators, estimatedMemorySize), TSStatusCode.MPP_MEMORY_NOT_ENOUGH.getStatusCode());
            }
            this.freeMemoryForOperators -= estimatedMemorySize;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("[ConsumeMemory] consume: {}, current remaining memory: {}", (Object)estimatedMemorySize, (Object)this.freeMemoryForOperators);
            }
        }
        stateMachine.addStateChangeListener(newState -> {
            if (newState.isDone()) {
                try (SetThreadName fragmentInstanceName = new SetThreadName(stateMachine.getFragmentInstanceId().getFullId());){
                    LocalExecutionPlanner localExecutionPlanner = this;
                    synchronized (localExecutionPlanner) {
                        this.freeMemoryForOperators += estimatedMemorySize;
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("[ReleaseMemory] release: {}, current remaining memory: {}", (Object)estimatedMemorySize, (Object)this.freeMemoryForOperators);
                        }
                    }
                }
            }
        });
    }

    private List<PartialPath> collectSourcePaths(LocalExecutionPlanContext context) {
        ArrayList<PartialPath> sourcePaths = new ArrayList<PartialPath>();
        context.getPipelineDriverFactories().forEach(pipeline -> sourcePaths.addAll(((DataDriverContext)pipeline.getDriverContext()).getPaths()));
        return sourcePaths;
    }

    private static class InstanceHolder {
        private static final LocalExecutionPlanner INSTANCE = new LocalExecutionPlanner();

        private InstanceHolder() {
        }
    }
}

