/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.process;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.mpp.common.header.ColumnHeader;
import org.apache.iotdb.db.mpp.common.header.ColumnHeaderConstant;
import org.apache.iotdb.db.mpp.execution.operator.Operator;
import org.apache.iotdb.db.mpp.execution.operator.OperatorContext;
import org.apache.iotdb.db.mpp.execution.operator.process.AbstractIntoOperator;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.InputLocation;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumnBuilder;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.Pair;

public class IntoOperator
extends AbstractIntoOperator {
    private final List<Pair<String, PartialPath>> sourceTargetPathPairList;

    public IntoOperator(OperatorContext operatorContext, Operator child, List<TSDataType> inputColumnTypes, Map<PartialPath, Map<String, InputLocation>> targetPathToSourceInputLocationMap, Map<PartialPath, Map<String, TSDataType>> targetPathToDataTypeMap, Map<String, Boolean> targetDeviceToAlignedMap, List<Pair<String, PartialPath>> sourceTargetPathPairList, Map<String, InputLocation> sourceColumnToInputLocationMap, ExecutorService intoOperationExecutor, long statementSizePerLine) {
        super(operatorContext, child, inputColumnTypes, sourceColumnToInputLocationMap, intoOperationExecutor, statementSizePerLine);
        this.sourceTargetPathPairList = sourceTargetPathPairList;
        this.insertTabletStatementGenerators = IntoOperator.constructInsertTabletStatementGenerators(targetPathToSourceInputLocationMap, targetPathToDataTypeMap, targetDeviceToAlignedMap, this.typeConvertors, this.maxRowNumberInStatement);
    }

    @Override
    protected boolean processTsBlock(TsBlock inputTsBlock) {
        if (inputTsBlock == null || inputTsBlock.isEmpty()) {
            return true;
        }
        int readIndex = 0;
        while (readIndex < inputTsBlock.getPositionCount()) {
            int lastReadIndex = readIndex;
            for (AbstractIntoOperator.InsertTabletStatementGenerator generator : this.insertTabletStatementGenerators) {
                lastReadIndex = Math.max(lastReadIndex, generator.processTsBlock(inputTsBlock, readIndex));
            }
            readIndex = lastReadIndex;
            if (!this.insertMultiTabletsInternally(true)) continue;
            this.cachedTsBlock = inputTsBlock.subTsBlock(readIndex);
            return false;
        }
        return true;
    }

    @Override
    protected TsBlock tryToReturnResultTsBlock() {
        if (this.insertMultiTabletsInternally(false)) {
            return null;
        }
        this.finished = true;
        return this.constructResultTsBlock();
    }

    private TsBlock constructResultTsBlock() {
        List outputDataTypes = ColumnHeaderConstant.selectIntoColumnHeaders.stream().map(ColumnHeader::getColumnType).collect(Collectors.toList());
        TsBlockBuilder resultTsBlockBuilder = new TsBlockBuilder(outputDataTypes);
        TimeColumnBuilder timeColumnBuilder = resultTsBlockBuilder.getTimeColumnBuilder();
        ColumnBuilder[] columnBuilders = resultTsBlockBuilder.getValueColumnBuilders();
        for (Pair<String, PartialPath> sourceTargetPathPair : this.sourceTargetPathPairList) {
            timeColumnBuilder.writeLong(0L);
            columnBuilders[0].writeBinary(new Binary((String)sourceTargetPathPair.left));
            columnBuilders[1].writeBinary(new Binary(((PartialPath)sourceTargetPathPair.right).toString()));
            columnBuilders[2].writeInt(this.findWritten(((PartialPath)sourceTargetPathPair.right).getDevice(), ((PartialPath)sourceTargetPathPair.right).getMeasurement()));
            resultTsBlockBuilder.declarePosition();
        }
        return resultTsBlockBuilder.build();
    }
}

