/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.storagegroup;

import org.apache.iotdb.commons.service.metric.MetricService;
import org.apache.iotdb.db.engine.storagegroup.DataRegionInfo;
import org.apache.iotdb.db.engine.storagegroup.TsFileProcessorInfoMetrics;
import org.apache.iotdb.metrics.metricsets.IMetricSet;

public class TsFileProcessorInfo {
    private final DataRegionInfo dataRegionInfo;
    private long memCost;
    private final TsFileProcessorInfoMetrics metrics;

    public TsFileProcessorInfo(DataRegionInfo dataRegionInfo) {
        this.dataRegionInfo = dataRegionInfo;
        this.memCost = 0L;
        this.metrics = new TsFileProcessorInfoMetrics(dataRegionInfo.getDataRegion().getDatabaseName(), this);
        MetricService.getInstance().addMetricSet((IMetricSet)this.metrics);
    }

    public void addTSPMemCost(long cost) {
        this.memCost += cost;
        this.dataRegionInfo.addStorageGroupMemCost(cost);
    }

    public void releaseTSPMemCost(long cost) {
        this.dataRegionInfo.releaseStorageGroupMemCost(cost);
        this.memCost -= cost;
    }

    public void clear() {
        this.dataRegionInfo.releaseStorageGroupMemCost(this.memCost);
        this.memCost = 0L;
        MetricService.getInstance().removeMetricSet((IMetricSet)this.metrics);
    }

    public long getMemCost() {
        return this.memCost;
    }
}

