/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.client.async;

import java.io.IOException;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.client.ClientManager;
import org.apache.iotdb.commons.client.ThriftClient;
import org.apache.iotdb.commons.client.factory.AsyncThriftClientFactory;
import org.apache.iotdb.commons.client.property.ThriftClientProperty;
import org.apache.iotdb.mpp.rpc.thrift.IDataNodeRPCService;
import org.apache.iotdb.rpc.TNonblockingSocketWrapper;
import org.apache.thrift.async.TAsyncClientManager;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.TNonblockingTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncDataNodeInternalServiceClient
extends IDataNodeRPCService.AsyncClient
implements ThriftClient {
    private static final Logger logger = LoggerFactory.getLogger(AsyncDataNodeInternalServiceClient.class);
    private final TEndPoint endpoint;
    private final ClientManager<TEndPoint, AsyncDataNodeInternalServiceClient> clientManager;

    public AsyncDataNodeInternalServiceClient(TProtocolFactory protocolFactory, int connectionTimeout, TEndPoint endpoint, TAsyncClientManager tClientManager, ClientManager<TEndPoint, AsyncDataNodeInternalServiceClient> clientManager) throws IOException {
        super(protocolFactory, tClientManager, (TNonblockingTransport)TNonblockingSocketWrapper.wrap((String)endpoint.getIp(), (int)endpoint.getPort(), (int)connectionTimeout));
        this.endpoint = endpoint;
        this.clientManager = clientManager;
    }

    public TEndPoint getTEndpoint() {
        return this.endpoint;
    }

    public ClientManager<TEndPoint, AsyncDataNodeInternalServiceClient> getClientManager() {
        return this.clientManager;
    }

    public void onComplete() {
        super.onComplete();
        this.returnSelf();
    }

    public void onError(Exception e) {
        super.onError(e);
        ThriftClient.resolveException(e, this);
        this.returnSelf();
    }

    @Override
    public void invalidate() {
        if (!this.hasError()) {
            super.onError(new Exception("This client has been invalidated"));
        }
    }

    @Override
    public void invalidateAll() {
        this.clientManager.clear(this.endpoint);
    }

    private void returnSelf() {
        this.clientManager.returnClient(this.endpoint, this);
    }

    private void close() {
        this.___transport.close();
        this.___currentMethod = null;
    }

    public boolean isReady() {
        try {
            this.checkReady();
            return true;
        }
        catch (Exception e) {
            logger.error("Unexpected exception occurs in {} : {}", (Object)this, (Object)e.getMessage());
            return false;
        }
    }

    public String toString() {
        return String.format("AsyncDataNodeInternalServiceClient{%s}", this.endpoint);
    }

    public static class Factory
    extends AsyncThriftClientFactory<TEndPoint, AsyncDataNodeInternalServiceClient> {
        public Factory(ClientManager<TEndPoint, AsyncDataNodeInternalServiceClient> clientManager, ThriftClientProperty thriftClientProperty, String threadName) {
            super(clientManager, thriftClientProperty, threadName);
        }

        public void destroyObject(TEndPoint endPoint, PooledObject<AsyncDataNodeInternalServiceClient> pooledObject) {
            ((AsyncDataNodeInternalServiceClient)pooledObject.getObject()).close();
        }

        public PooledObject<AsyncDataNodeInternalServiceClient> makeObject(TEndPoint endPoint) throws Exception {
            return new DefaultPooledObject((Object)new AsyncDataNodeInternalServiceClient(this.thriftClientProperty.getProtocolFactory(), this.thriftClientProperty.getConnectionTimeoutMs(), endPoint, this.tManagers[this.clientCnt.incrementAndGet() % this.tManagers.length], this.clientManager));
        }

        public boolean validateObject(TEndPoint endPoint, PooledObject<AsyncDataNodeInternalServiceClient> pooledObject) {
            return ((AsyncDataNodeInternalServiceClient)pooledObject.getObject()).isReady();
        }
    }
}

