/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics.metricsets.disk;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.metrics.metricsets.disk.LinuxDiskMetricsManager;
import org.apache.iotdb.metrics.metricsets.disk.MacDiskMetricsManager;
import org.apache.iotdb.metrics.metricsets.disk.WindowsDiskMetricsManager;

public interface IDiskMetricsManager {
    default public Map<String, Double> getReadDataSizeForDisk() {
        return Collections.emptyMap();
    }

    default public Map<String, Double> getWriteDataSizeForDisk() {
        return Collections.emptyMap();
    }

    default public Map<String, Long> getReadOperationCountForDisk() {
        return Collections.emptyMap();
    }

    default public Map<String, Long> getWriteOperationCountForDisk() {
        return Collections.emptyMap();
    }

    default public Map<String, Long> getMergedWriteOperationForDisk() {
        return Collections.emptyMap();
    }

    default public Map<String, Long> getMergedReadOperationForDisk() {
        return Collections.emptyMap();
    }

    default public Map<String, Long> getReadCostTimeForDisk() {
        return Collections.emptyMap();
    }

    default public Map<String, Long> getWriteCostTimeForDisk() {
        return Collections.emptyMap();
    }

    default public Map<String, Double> getIoUtilsPercentage() {
        return Collections.emptyMap();
    }

    default public Map<String, Double> getAvgReadCostTimeOfEachOpsForDisk() {
        return Collections.emptyMap();
    }

    default public Map<String, Double> getAvgWriteCostTimeOfEachOpsForDisk() {
        return Collections.emptyMap();
    }

    default public Map<String, Double> getAvgSizeOfEachReadForDisk() {
        return Collections.emptyMap();
    }

    default public Map<String, Double> getAvgSizeOfEachWriteForDisk() {
        return Collections.emptyMap();
    }

    default public Map<String, Double> getQueueSizeForDisk() {
        return Collections.emptyMap();
    }

    default public double getActualReadDataSizeForProcess() {
        return 0.0;
    }

    default public double getActualWriteDataSizeForProcess() {
        return 0.0;
    }

    default public long getReadOpsCountForProcess() {
        return 0L;
    }

    default public long getWriteOpsCountForProcess() {
        return 0L;
    }

    default public double getAttemptReadSizeForProcess() {
        return 0.0;
    }

    default public double getAttemptWriteSizeForProcess() {
        return 0.0;
    }

    default public Set<String> getDiskIds() {
        return Collections.emptySet();
    }

    public static IDiskMetricsManager getDiskMetricsManager() {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.startsWith("windows")) {
            return new WindowsDiskMetricsManager();
        }
        if (os.startsWith("linux")) {
            return new LinuxDiskMetricsManager();
        }
        return new MacDiskMetricsManager();
    }
}

