/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.schema;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathDeserializeUtil;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.confignode.client.DataNodeRequestType;
import org.apache.iotdb.confignode.client.async.AsyncDataNodeClientPool;
import org.apache.iotdb.confignode.client.async.handlers.AsyncClientHandler;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.exception.ProcedureException;
import org.apache.iotdb.confignode.procedure.exception.ProcedureSuspendedException;
import org.apache.iotdb.confignode.procedure.exception.ProcedureYieldException;
import org.apache.iotdb.confignode.procedure.impl.schema.DataNodeRegionTask;
import org.apache.iotdb.confignode.procedure.impl.statemachine.StateMachineProcedure;
import org.apache.iotdb.confignode.procedure.state.schema.UnsetTemplateState;
import org.apache.iotdb.confignode.procedure.store.ProcedureType;
import org.apache.iotdb.db.metadata.template.Template;
import org.apache.iotdb.db.metadata.template.TemplateInternalRPCUpdateType;
import org.apache.iotdb.db.metadata.template.TemplateInternalRPCUtil;
import org.apache.iotdb.mpp.rpc.thrift.TCountPathsUsingTemplateReq;
import org.apache.iotdb.mpp.rpc.thrift.TCountPathsUsingTemplateResp;
import org.apache.iotdb.mpp.rpc.thrift.TUpdateTemplateReq;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnsetTemplateProcedure
extends StateMachineProcedure<ConfigNodeProcedureEnv, UnsetTemplateState> {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnsetTemplateProcedure.class);
    private String queryId;
    private Template template;
    private PartialPath path;
    private boolean alreadyRollback = false;
    private transient ByteBuffer addTemplateSetInfo;
    private transient ByteBuffer invalidateTemplateSetInfo;

    public UnsetTemplateProcedure() {
    }

    public UnsetTemplateProcedure(String queryId, Template template, PartialPath path) {
        this.queryId = queryId;
        this.template = template;
        this.path = path;
    }

    /*
     * Exception decompiling
     */
    @Override
    protected StateMachineProcedure.Flow executeFromState(ConfigNodeProcedureEnv env, UnsetTemplateState state) throws ProcedureSuspendedException, ProcedureYieldException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void constructBlackList(ConfigNodeProcedureEnv env) {
        TSStatus status = env.getConfigManager().getClusterSchemaManager().preUnsetSchemaTemplate(this.template.getId(), this.path);
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            this.setNextState(UnsetTemplateState.CLEAN_DATANODE_TEMPLATE_CACHE);
        } else {
            this.setFailure(new ProcedureException((Throwable)new IoTDBException(status.getMessage(), status.getCode())));
        }
    }

    private void invalidateCache(ConfigNodeProcedureEnv env) {
        try {
            this.executeInvalidateCache(env);
            this.setNextState(UnsetTemplateState.CHECK_DATANODE_TEMPLATE_ACTIVATION);
        }
        catch (ProcedureException e) {
            this.setFailure(e);
        }
    }

    private void executeInvalidateCache(ConfigNodeProcedureEnv env) throws ProcedureException {
        Map<Integer, TDataNodeLocation> dataNodeLocationMap = env.getConfigManager().getNodeManager().getRegisteredDataNodeLocations();
        TUpdateTemplateReq invalidateTemplateSetInfoReq = new TUpdateTemplateReq();
        invalidateTemplateSetInfoReq.setType(TemplateInternalRPCUpdateType.INVALIDATE_TEMPLATE_SET_INFO.toByte());
        invalidateTemplateSetInfoReq.setTemplateInfo(this.getInvalidateTemplateSetInfo());
        AsyncClientHandler clientHandler = new AsyncClientHandler(DataNodeRequestType.UPDATE_TEMPLATE, invalidateTemplateSetInfoReq, dataNodeLocationMap);
        AsyncDataNodeClientPool.getInstance().sendAsyncRequestToDataNodeWithRetry(clientHandler);
        Map statusMap = clientHandler.getResponseMap();
        for (TSStatus status : statusMap.values()) {
            if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) continue;
            LOGGER.error("Failed to invalidate template cache of template {} set on {}", (Object)this.template.getName(), (Object)this.path);
            throw new ProcedureException(new MetadataException("Invalidate template cache failed"));
        }
    }

    private long checkDataNodeTemplateActivation(ConfigNodeProcedureEnv env) {
        PathPatternTree patternTree = new PathPatternTree();
        patternTree.appendPathPattern(this.path);
        patternTree.appendPathPattern(this.path.concatNode("**"));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            patternTree.serialize(dataOutputStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        final ByteBuffer patternTreeBytes = ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
        Map<TConsensusGroupId, TRegionReplicaSet> relatedSchemaRegionGroup = env.getConfigManager().getRelatedSchemaRegionGroup(patternTree);
        DataNodeRegionTask<TCountPathsUsingTemplateResp> regionTask = new DataNodeRegionTask<TCountPathsUsingTemplateResp>(env, relatedSchemaRegionGroup, false){

            @Override
            protected Map<Integer, TSStatus> sendRequest(TDataNodeLocation dataNodeLocation, List<TConsensusGroupId> consensusGroupIdList) {
                HashMap<Integer, TDataNodeLocation> dataNodeLocationMap = new HashMap<Integer, TDataNodeLocation>();
                dataNodeLocationMap.put(dataNodeLocation.getDataNodeId(), dataNodeLocation);
                AsyncClientHandler clientHandler = new AsyncClientHandler(DataNodeRequestType.COUNT_PATHS_USING_TEMPLATE, new TCountPathsUsingTemplateReq(UnsetTemplateProcedure.this.template.getId(), patternTreeBytes, consensusGroupIdList), dataNodeLocationMap);
                AsyncDataNodeClientPool.getInstance().sendAsyncRequestToDataNodeWithRetry(clientHandler);
                HashMap<Integer, TSStatus> statusMap = new HashMap<Integer, TSStatus>();
                clientHandler.getResponseMap().forEach((k, v) -> {
                    if (v.getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                        this.saveDataNodeResponse((Integer)k, v);
                    }
                    statusMap.put((Integer)k, v.getStatus());
                });
                return statusMap;
            }

            @Override
            protected boolean hasFailure() {
                return UnsetTemplateProcedure.this.isFailed();
            }

            @Override
            protected void onExecutionFailure(TDataNodeLocation dataNodeLocation) {
                LOGGER.error("Failed to execute [check DataNode template activation] of unset template {} from {} on {}", new Object[]{UnsetTemplateProcedure.this.template.getName(), UnsetTemplateProcedure.this.path, dataNodeLocation});
                UnsetTemplateProcedure.this.setFailure(new ProcedureException(new MetadataException(String.format("Unset template %s from %s failed when [check DataNode template activation]", UnsetTemplateProcedure.this.template.getName(), UnsetTemplateProcedure.this.path))));
            }

            @Override
            protected void onAllReplicasetFailure(TConsensusGroupId consensusGroupId) {
                UnsetTemplateProcedure.this.setFailure(new ProcedureException(new MetadataException(String.format("Unset template %s from %s failed when [check DataNode template activation] because all replicaset of schemaRegion %s failed.", UnsetTemplateProcedure.this.template.getName(), UnsetTemplateProcedure.this.path, consensusGroupId.id))));
            }
        };
        regionTask.execute();
        if (this.isFailed()) {
            return 0L;
        }
        long result = 0L;
        Map dataNodeResponseMap = regionTask.getResponseMap();
        for (List respList : dataNodeResponseMap.values()) {
            for (TCountPathsUsingTemplateResp resp : respList) {
                result += resp.getCount();
            }
        }
        return result;
    }

    private void unsetTemplate(ConfigNodeProcedureEnv env) {
        TSStatus status = env.getConfigManager().getClusterSchemaManager().unsetSchemaTemplateInBlackList(this.template.getId(), this.path);
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            this.setNextState(UnsetTemplateState.CLEAN_DATANODE_TEMPLATE_CACHE);
        } else {
            this.setFailure(new ProcedureException((Throwable)new IoTDBException(status.getMessage(), status.getCode())));
        }
    }

    @Override
    protected void rollbackState(ConfigNodeProcedureEnv env, UnsetTemplateState unsetTemplateState) throws IOException, InterruptedException, ProcedureException {
        if (this.alreadyRollback) {
            return;
        }
        this.alreadyRollback = true;
        ProcedureException rollbackException = null;
        try {
            this.executeRollbackInvalidateCache(env);
            TSStatus status = env.getConfigManager().getClusterSchemaManager().rollbackPreUnsetSchemaTemplate(this.template.getId(), this.path);
            if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                return;
            }
            LOGGER.error("Failed to rollback pre unset template operation of template {} set on {}", (Object)this.template.getName(), (Object)this.path);
            rollbackException = new ProcedureException(new MetadataException("Rollback template pre unset failed because of" + status.getMessage()));
        }
        catch (ProcedureException e) {
            rollbackException = e;
        }
        try {
            this.executeInvalidateCache(env);
            this.setFailure(rollbackException);
        }
        catch (ProcedureException exception) {
            this.setFailure(new ProcedureException(new MetadataException("Rollback unset template failed and the cluster template info management is strictly broken. Please try unset again.")));
        }
    }

    private void executeRollbackInvalidateCache(ConfigNodeProcedureEnv env) throws ProcedureException {
        Map<Integer, TDataNodeLocation> dataNodeLocationMap = env.getConfigManager().getNodeManager().getRegisteredDataNodeLocations();
        TUpdateTemplateReq rollbackTemplateSetInfoReq = new TUpdateTemplateReq();
        rollbackTemplateSetInfoReq.setType(TemplateInternalRPCUpdateType.ADD_TEMPLATE_SET_INFO.toByte());
        rollbackTemplateSetInfoReq.setTemplateInfo(this.getAddTemplateSetInfo());
        AsyncClientHandler clientHandler = new AsyncClientHandler(DataNodeRequestType.UPDATE_TEMPLATE, rollbackTemplateSetInfoReq, dataNodeLocationMap);
        AsyncDataNodeClientPool.getInstance().sendAsyncRequestToDataNodeWithRetry(clientHandler);
        Map statusMap = clientHandler.getResponseMap();
        for (TSStatus status : statusMap.values()) {
            if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) continue;
            LOGGER.error("Failed to rollback template cache of template {} set on {}", (Object)this.template.getName(), (Object)this.path);
            throw new ProcedureException(new MetadataException("Rollback template cache failed"));
        }
    }

    @Override
    protected boolean isRollbackSupported(UnsetTemplateState unsetTemplateState) {
        return true;
    }

    @Override
    protected UnsetTemplateState getState(int stateId) {
        return UnsetTemplateState.values()[stateId];
    }

    @Override
    protected int getStateId(UnsetTemplateState unsetTemplateState) {
        return unsetTemplateState.ordinal();
    }

    @Override
    protected UnsetTemplateState getInitialState() {
        return UnsetTemplateState.CONSTRUCT_BLACK_LIST;
    }

    public String getQueryId() {
        return this.queryId;
    }

    public int getTemplateId() {
        return this.template.getId();
    }

    public String getTemplateName() {
        return this.template.getName();
    }

    public Template getTemplate() {
        return this.template;
    }

    public PartialPath getPath() {
        return this.path;
    }

    private ByteBuffer getAddTemplateSetInfo() {
        if (this.addTemplateSetInfo == null) {
            this.addTemplateSetInfo = ByteBuffer.wrap(TemplateInternalRPCUtil.generateAddTemplateSetInfoBytes((Template)this.template, (String)this.path.getFullPath()));
        }
        return this.addTemplateSetInfo;
    }

    private ByteBuffer getInvalidateTemplateSetInfo() {
        if (this.invalidateTemplateSetInfo == null) {
            this.invalidateTemplateSetInfo = ByteBuffer.wrap(TemplateInternalRPCUtil.generateInvalidateTemplateSetInfoBytes((int)this.template.getId(), (String)this.path.getFullPath()));
        }
        return this.invalidateTemplateSetInfo;
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeShort(ProcedureType.UNSET_TEMPLATE_PROCEDURE.getTypeCode());
        super.serialize(stream);
        ReadWriteIOUtils.write((String)this.queryId, (OutputStream)stream);
        this.template.serialize((OutputStream)stream);
        this.path.serialize((OutputStream)stream);
        ReadWriteIOUtils.write((Boolean)this.alreadyRollback, (OutputStream)stream);
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        super.deserialize(byteBuffer);
        this.queryId = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        this.template = new Template();
        this.template.deserialize(byteBuffer);
        this.path = (PartialPath)PathDeserializeUtil.deserialize((ByteBuffer)byteBuffer);
        this.alreadyRollback = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
    }
}

