/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.partition.heartbeat;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.commons.cluster.RegionStatus;
import org.apache.iotdb.confignode.manager.partition.heartbeat.RegionHeartbeatSample;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class RegionStatistics {
    private RegionStatus regionStatus;

    public RegionStatistics() {
    }

    public RegionStatistics(RegionStatus regionStatus) {
        this.regionStatus = regionStatus;
    }

    public RegionStatus getRegionStatus() {
        return this.regionStatus;
    }

    public RegionStatistics deepCopy() {
        return new RegionStatistics(this.regionStatus);
    }

    public RegionHeartbeatSample convertToRegionHeartbeatSample() {
        long currentTime = System.currentTimeMillis();
        return new RegionHeartbeatSample(currentTime, currentTime, this.regionStatus);
    }

    public void serialize(OutputStream stream) throws IOException {
        ReadWriteIOUtils.write((String)this.regionStatus.getStatus(), (OutputStream)stream);
    }

    public void deserialize(InputStream inputStream) throws IOException {
        this.regionStatus = RegionStatus.parse((String)ReadWriteIOUtils.readString((InputStream)inputStream));
    }

    public void deserialize(ByteBuffer buffer) {
        this.regionStatus = RegionStatus.parse((String)ReadWriteIOUtils.readString((ByteBuffer)buffer));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegionStatistics that = (RegionStatistics)o;
        return this.regionStatus == that.regionStatus;
    }

    public int hashCode() {
        return Objects.hash(this.regionStatus);
    }

    public String toString() {
        return "RegionStatistics{regionStatus=" + this.regionStatus + '}';
    }
}

