/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.externalpipe;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.db.sync.datasource.PipeStorageGroupInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtPipePluginConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(ExtPipePluginConfiguration.class);
    public static final int DEFAULT_NUM_OF_THREADS = 1;
    public static final int DEFAULT_ATTEMPT_TIMES = 3;
    public static final int DEFAULT_BACKOFF_INTERVAL = 1000;
    public static final int DEFAULT_OPERATION_BATCH_SIZE = 100000;
    private int numOfThreads = 1;
    private int attemptTimes = 3;
    private int backOffInterval = 1000;
    private int operationBatchSize = 100000;
    private String pipeName;
    private Map<String, PipeStorageGroupInfo>[] sgInfoBuckets;

    private ExtPipePluginConfiguration(String pipeName) {
        this.pipeName = pipeName;
    }

    public int getNumOfThreads() {
        return this.numOfThreads;
    }

    public int getAttemptTimes() {
        return this.attemptTimes;
    }

    public int getBackOffInterval() {
        return this.backOffInterval;
    }

    public int getOperationBatchSize() {
        return this.operationBatchSize;
    }

    public Map<String, PipeStorageGroupInfo> getBucketSgInfoMap(int threadIndex) {
        if (threadIndex >= this.sgInfoBuckets.length) {
            logger.error("getBucketSgInfoMap(), error. pipeName = {}, threadIndex = {}.", (Object)this.pipeName, (Object)threadIndex);
            return null;
        }
        return this.sgInfoBuckets[threadIndex];
    }

    static /* synthetic */ Map[] access$202(ExtPipePluginConfiguration x0, Map[] x1) {
        x0.sgInfoBuckets = x1;
        return x1;
    }

    public static class Builder {
        private final ExtPipePluginConfiguration configuration;

        public Builder(String pipeName) {
            this.configuration = new ExtPipePluginConfiguration(pipeName);
        }

        public Builder numOfThreads(int numOfThreads) {
            if (numOfThreads < 1) {
                throw new IllegalArgumentException("Invalid number of threads. Should be larger than 0.");
            }
            this.configuration.numOfThreads = numOfThreads;
            this.initSgInfoBuckets(numOfThreads);
            return this;
        }

        private void initSgInfoBuckets(int bucketNum) {
            ExtPipePluginConfiguration.access$202(this.configuration, new Map[bucketNum]);
            for (int i = 0; i < bucketNum; ++i) {
                ((ExtPipePluginConfiguration)this.configuration).sgInfoBuckets[i] = new ConcurrentHashMap();
            }
        }

        public Builder attemptTimes(int attemptTimes) {
            if (attemptTimes < 1) {
                throw new IllegalArgumentException("Invalid attempt times. Should be larger than 0.");
            }
            this.configuration.attemptTimes = attemptTimes;
            return this;
        }

        public Builder backOffInterval(int backOffInterval) {
            if (backOffInterval < 1) {
                throw new IllegalArgumentException("Invalid backoff interval. Should be larger than 0.");
            }
            this.configuration.backOffInterval = backOffInterval;
            return this;
        }

        public Builder operationBatchSize(int operationBatchSize) {
            if (operationBatchSize < 1) {
                throw new IllegalArgumentException("Invalid operation batch size. Should be larger than 0.");
            }
            this.configuration.operationBatchSize = operationBatchSize;
            return this;
        }

        public ExtPipePluginConfiguration build() {
            return this.configuration;
        }
    }
}

