/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service.thrift.impl;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.consensus.ConsensusGroupId;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.commons.consensus.SchemaRegionId;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.consensus.common.Peer;
import org.apache.iotdb.consensus.common.response.ConsensusGenericResponse;
import org.apache.iotdb.db.consensus.DataRegionConsensusImpl;
import org.apache.iotdb.db.consensus.SchemaRegionConsensusImpl;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.exception.DataRegionException;
import org.apache.iotdb.db.metadata.schemaregion.SchemaEngine;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataNodeRegionManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataNodeRegionManager.class);
    private final SchemaEngine schemaEngine = SchemaEngine.getInstance();
    private final StorageEngine storageEngine = StorageEngine.getInstance();
    private final Map<SchemaRegionId, ReentrantReadWriteLock> schemaRegionLockMap = new ConcurrentHashMap<SchemaRegionId, ReentrantReadWriteLock>();
    private final Map<DataRegionId, ReentrantReadWriteLock> dataRegionLockMap = new ConcurrentHashMap<DataRegionId, ReentrantReadWriteLock>();

    public static DataNodeRegionManager getInstance() {
        return DataNodeRegionManagerHolder.INSTANCE;
    }

    public void init() {
        this.schemaEngine.getAllSchemaRegions().forEach(schemaRegion -> this.schemaRegionLockMap.put(schemaRegion.getSchemaRegionId(), new ReentrantReadWriteLock(false)));
        this.storageEngine.getAllDataRegionIds().forEach(dataRegionId -> this.dataRegionLockMap.put((DataRegionId)dataRegionId, new ReentrantReadWriteLock(false)));
    }

    public void clear() {
        this.schemaRegionLockMap.clear();
        this.dataRegionLockMap.clear();
    }

    private DataNodeRegionManager() {
    }

    public ReentrantReadWriteLock getRegionLock(ConsensusGroupId consensusGroupId) {
        return consensusGroupId instanceof DataRegionId ? this.dataRegionLockMap.get((DataRegionId)consensusGroupId) : this.schemaRegionLockMap.get((SchemaRegionId)consensusGroupId);
    }

    public TSStatus createSchemaRegion(TRegionReplicaSet regionReplicaSet, String storageGroup) {
        TSStatus tsStatus;
        try {
            PartialPath storageGroupPartitionPath = new PartialPath(storageGroup);
            SchemaRegionId schemaRegionId = new SchemaRegionId(regionReplicaSet.getRegionId().getId());
            this.schemaEngine.createSchemaRegion(storageGroupPartitionPath, schemaRegionId);
            this.schemaRegionLockMap.put(schemaRegionId, new ReentrantReadWriteLock(false));
            ArrayList<Peer> peers = new ArrayList<Peer>();
            for (TDataNodeLocation dataNodeLocation : regionReplicaSet.getDataNodeLocations()) {
                TEndPoint endpoint = new TEndPoint(dataNodeLocation.getSchemaRegionConsensusEndPoint().getIp(), dataNodeLocation.getSchemaRegionConsensusEndPoint().getPort());
                peers.add(new Peer((ConsensusGroupId)schemaRegionId, dataNodeLocation.getDataNodeId(), endpoint));
            }
            ConsensusGenericResponse consensusGenericResponse = SchemaRegionConsensusImpl.getInstance().createPeer((ConsensusGroupId)schemaRegionId, peers);
            if (consensusGenericResponse.isSuccess()) {
                tsStatus = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
            } else {
                tsStatus = new TSStatus(TSStatusCode.CREATE_REGION_ERROR.getStatusCode());
                tsStatus.setMessage(consensusGenericResponse.getException().getMessage());
            }
        }
        catch (IllegalPathException e1) {
            LOGGER.error("Create Schema Region {} failed because path is illegal.", (Object)storageGroup);
            tsStatus = new TSStatus(TSStatusCode.ILLEGAL_PATH.getStatusCode());
            tsStatus.setMessage("Create Schema Region failed because storageGroup path is illegal.");
        }
        catch (MetadataException e2) {
            LOGGER.error("Create Schema Region {} failed because {}", (Object)storageGroup, (Object)e2.getMessage());
            tsStatus = new TSStatus(TSStatusCode.CREATE_REGION_ERROR.getStatusCode());
            tsStatus.setMessage(String.format("Create Schema Region failed because of %s", e2.getMessage()));
        }
        return tsStatus;
    }

    public TSStatus createDataRegion(TRegionReplicaSet regionReplicaSet, String storageGroup, long ttl) {
        TSStatus tsStatus;
        try {
            DataRegionId dataRegionId = new DataRegionId(regionReplicaSet.getRegionId().getId());
            this.storageEngine.createDataRegion(dataRegionId, storageGroup, ttl);
            this.dataRegionLockMap.put(dataRegionId, new ReentrantReadWriteLock(false));
            ArrayList<Peer> peers = new ArrayList<Peer>();
            for (TDataNodeLocation dataNodeLocation : regionReplicaSet.getDataNodeLocations()) {
                TEndPoint endpoint = new TEndPoint(dataNodeLocation.getDataRegionConsensusEndPoint().getIp(), dataNodeLocation.getDataRegionConsensusEndPoint().getPort());
                peers.add(new Peer((ConsensusGroupId)dataRegionId, dataNodeLocation.getDataNodeId(), endpoint));
            }
            ConsensusGenericResponse consensusGenericResponse = DataRegionConsensusImpl.getInstance().createPeer((ConsensusGroupId)dataRegionId, peers);
            if (consensusGenericResponse.isSuccess()) {
                tsStatus = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
            } else {
                tsStatus = new TSStatus(TSStatusCode.CREATE_REGION_ERROR.getStatusCode());
                tsStatus.setMessage(consensusGenericResponse.getException().getMessage());
            }
        }
        catch (DataRegionException e) {
            LOGGER.error("Create Data Region {} failed because {}", (Object)storageGroup, (Object)e.getMessage());
            tsStatus = new TSStatus(TSStatusCode.CREATE_REGION_ERROR.getStatusCode());
            tsStatus.setMessage(String.format("Create Data Region failed because of %s", e.getMessage()));
        }
        return tsStatus;
    }

    public TSStatus createNewRegion(ConsensusGroupId regionId, String storageGroup, long ttl) {
        TSStatus status = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        LOGGER.info("start to create new region {}", (Object)regionId);
        try {
            if (regionId instanceof DataRegionId) {
                DataRegionId dataRegionId = (DataRegionId)regionId;
                this.storageEngine.createDataRegion(dataRegionId, storageGroup, ttl);
                this.dataRegionLockMap.put(dataRegionId, new ReentrantReadWriteLock(false));
            } else {
                SchemaRegionId schemaRegionId = (SchemaRegionId)regionId;
                this.schemaEngine.createSchemaRegion(new PartialPath(storageGroup), schemaRegionId);
                this.schemaRegionLockMap.put(schemaRegionId, new ReentrantReadWriteLock(false));
            }
        }
        catch (Exception e) {
            LOGGER.error("create new region {} error", (Object)regionId, (Object)e);
            status.setCode(TSStatusCode.CREATE_REGION_ERROR.getStatusCode());
            status.setMessage("create new region " + regionId + "error,  exception:" + e.getMessage());
            return status;
        }
        status.setMessage("create new region " + regionId + " succeed");
        LOGGER.info("succeed to create new region {}", (Object)regionId);
        return status;
    }

    public TSStatus deleteDataRegion(DataRegionId dataRegionId) {
        this.storageEngine.deleteDataRegion(dataRegionId);
        this.dataRegionLockMap.remove(dataRegionId);
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS, (String)"Execute successfully");
    }

    public TSStatus deleteSchemaRegion(SchemaRegionId schemaRegionId) {
        try {
            this.schemaEngine.deleteSchemaRegion(schemaRegionId);
            this.schemaRegionLockMap.remove(schemaRegionId);
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS, (String)"Execute successfully");
        }
        catch (MetadataException e) {
            LOGGER.error("{}: MetaData error: ", (Object)"IoTDB", (Object)e);
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.METADATA_ERROR, (String)e.getMessage());
        }
    }

    private static class DataNodeRegionManagerHolder {
        private static final DataNodeRegionManager INSTANCE = new DataNodeRegionManager();

        private DataNodeRegionManagerHolder() {
        }
    }
}

