/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.transformation.dag.transformer.unary;

import java.io.IOException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.mpp.transformation.api.LayerPointReader;
import org.apache.iotdb.db.mpp.transformation.api.YieldableState;
import org.apache.iotdb.db.mpp.transformation.dag.transformer.unary.UnaryTransformer;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public class DiffFunctionTransformer
extends UnaryTransformer {
    private final boolean ignoreNull;
    private double lastValue;
    private boolean lastValueIsNull = true;

    public DiffFunctionTransformer(LayerPointReader layerPointReader, boolean ignoreNull) {
        super(layerPointReader);
        this.ignoreNull = ignoreNull;
    }

    @Override
    public TSDataType getDataType() {
        return TSDataType.DOUBLE;
    }

    @Override
    public final YieldableState yieldValue() throws Exception {
        YieldableState yieldableState = this.layerPointReader.yield();
        if (!YieldableState.YIELDABLE.equals((Object)yieldableState)) {
            return yieldableState;
        }
        if (!this.isLayerPointReaderConstant) {
            this.cachedTime = this.layerPointReader.currentTime();
        }
        this.transformAndCache();
        this.layerPointReader.readyForNext();
        return YieldableState.YIELDABLE;
    }

    @Override
    protected void transformAndCache() throws QueryProcessException, IOException {
        if (this.layerPointReader.isCurrentNull()) {
            this.currentNull = true;
            this.lastValueIsNull |= !this.ignoreNull;
        } else {
            double currValue;
            switch (this.layerPointReaderDataType) {
                case INT32: {
                    currValue = this.layerPointReader.currentInt();
                    break;
                }
                case INT64: {
                    currValue = this.layerPointReader.currentLong();
                    break;
                }
                case FLOAT: {
                    currValue = this.layerPointReader.currentFloat();
                    break;
                }
                case DOUBLE: {
                    currValue = this.layerPointReader.currentDouble();
                    break;
                }
                default: {
                    throw new QueryProcessException("Unsupported data type: " + this.layerPointReader.getDataType().toString());
                }
            }
            if (this.lastValueIsNull) {
                this.currentNull = true;
            } else {
                this.cachedDouble = currValue - this.lastValue;
            }
            this.lastValue = currValue;
            this.lastValueIsNull = false;
        }
    }
}

