/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.process.fill.linear;

import java.util.Optional;
import org.apache.iotdb.db.mpp.execution.operator.process.fill.linear.LinearFill;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.FloatColumn;
import org.apache.iotdb.tsfile.read.common.block.column.FloatColumnBuilder;

public class FloatLinearFill
extends LinearFill {
    private float previousValue;
    private float nextValue;
    private float nextValueInCurrentColumn;

    @Override
    void fillValue(Column column, int index, Object array) {
        ((float[])array)[index] = column.getFloat(index);
    }

    @Override
    void fillValue(Object array, int index) {
        ((float[])array)[index] = this.getFilledValue();
    }

    @Override
    Object createValueArray(int size) {
        return new float[size];
    }

    @Override
    Column createNullValueColumn() {
        return FloatColumnBuilder.NULL_VALUE_BLOCK;
    }

    @Override
    Column createFilledValueColumn() {
        float filledValue = this.getFilledValue();
        return new FloatColumn(1, Optional.empty(), new float[]{filledValue});
    }

    @Override
    Column createFilledValueColumn(Object array, boolean[] isNull, boolean hasNullValue, int size) {
        if (hasNullValue) {
            return new FloatColumn(size, Optional.of(isNull), (float[])array);
        }
        return new FloatColumn(size, Optional.empty(), (float[])array);
    }

    @Override
    void updatePreviousValue(Column column, int index) {
        this.previousValue = column.getFloat(index);
    }

    @Override
    void updateNextValue(Column nextValueColumn, int index) {
        this.nextValue = nextValueColumn.getFloat(index);
    }

    @Override
    void updateNextValueInCurrentColumn(Column nextValueColumn, int index) {
        this.nextValueInCurrentColumn = nextValueColumn.getFloat(index);
    }

    @Override
    void updateNextValueInCurrentColumn() {
        this.nextValueInCurrentColumn = this.nextValue;
    }

    private float getFilledValue() {
        return (this.previousValue + this.nextValueInCurrentColumn) / 2.0f;
    }
}

