/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.process;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.mpp.execution.operator.AbstractOperator;
import org.apache.iotdb.db.mpp.execution.operator.Operator;
import org.apache.iotdb.db.mpp.execution.operator.OperatorContext;
import org.apache.iotdb.db.mpp.execution.operator.process.ProcessOperator;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;

public abstract class AbstractConsumeAllOperator
extends AbstractOperator
implements ProcessOperator {
    protected final List<Operator> children;
    protected final int inputOperatorsCount;
    protected final TsBlock[] inputTsBlocks;
    protected final boolean[] canCallNext;
    protected int readyChildIndex;

    protected AbstractConsumeAllOperator(OperatorContext operatorContext, List<Operator> children) {
        this.operatorContext = operatorContext;
        this.children = children;
        this.inputOperatorsCount = children.size();
        this.inputTsBlocks = new TsBlock[this.inputOperatorsCount];
        this.canCallNext = new boolean[this.inputOperatorsCount];
        for (int i = 0; i < this.inputOperatorsCount; ++i) {
            this.canCallNext[i] = false;
        }
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        boolean hasReadyChild = false;
        this.readyChildIndex = 0;
        ArrayList listenableFutures = new ArrayList();
        for (int i = 0; i < this.inputOperatorsCount; ++i) {
            if (!this.isEmpty(i)) continue;
            ListenableFuture<?> blocked = this.children.get(i).isBlocked();
            if (blocked.isDone()) {
                hasReadyChild = true;
                this.canCallNext[i] = true;
                this.readyChildIndex = i;
                continue;
            }
            listenableFutures.add(blocked);
        }
        return hasReadyChild || listenableFutures.isEmpty() ? NOT_BLOCKED : Futures.successfulAsList(listenableFutures);
    }

    protected boolean prepareInput() throws Exception {
        boolean allReady = true;
        for (int i = 0; i < this.inputOperatorsCount; ++i) {
            if (!this.isEmpty(i)) continue;
            if (this.canCallNext[i] && this.children.get(i).hasNextWithTimer()) {
                this.inputTsBlocks[i] = this.getNextTsBlock(i);
                this.canCallNext[i] = false;
                if (!this.isEmpty(i)) continue;
                allReady = false;
                continue;
            }
            allReady = false;
        }
        return allReady;
    }

    protected boolean isEmpty(int index) {
        return this.inputTsBlocks[index] == null || this.inputTsBlocks[index].isEmpty();
    }

    @Override
    public void close() throws Exception {
        for (Operator child : this.children) {
            child.close();
        }
    }

    protected TsBlock getNextTsBlock(int childIndex) throws Exception {
        return this.children.get(childIndex).nextWithTimer();
    }
}

