/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Uninterruptibles;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.mpp.common.QueryId;

public class QueryIdGenerator {
    private static final DateTimeFormatter TIMESTAMP_FORMAT = DateTimeFormatter.ofPattern("yyyyMMdd_HHmmss").withZone(ZoneOffset.UTC);
    private static final long BASE_SYSTEM_TIME_MILLIS = System.currentTimeMillis();
    private static final long BASE_NANO_TIME = System.nanoTime();
    private final String dataNodeId;
    @GuardedBy(value="this")
    private long lastTimeInDays;
    @GuardedBy(value="this")
    private long lastTimeInSeconds;
    @GuardedBy(value="this")
    private String lastTimestamp;
    @GuardedBy(value="this")
    private int counter;

    public QueryIdGenerator() {
        int dataNodeId = IoTDBDescriptor.getInstance().getConfig().getDataNodeId();
        Preconditions.checkArgument((dataNodeId != -1 ? 1 : 0) != 0, (Object)"DataNodeId should be init first!");
        this.dataNodeId = String.valueOf(dataNodeId);
    }

    public String getCoordinatorId() {
        return this.dataNodeId;
    }

    public synchronized QueryId createNextQueryId() {
        long now = this.nowInMillis();
        if (this.counter > 99999) {
            while (TimeUnit.MILLISECONDS.toSeconds(now) == this.lastTimeInSeconds) {
                long delta = TimeUnit.SECONDS.toMillis(this.lastTimeInSeconds + 1L) - now;
                Uninterruptibles.sleepUninterruptibly((long)delta, (TimeUnit)TimeUnit.MILLISECONDS);
                now = this.nowInMillis();
            }
            this.counter = 0;
        }
        if (TimeUnit.MILLISECONDS.toSeconds(now) != this.lastTimeInSeconds) {
            this.lastTimeInSeconds = TimeUnit.MILLISECONDS.toSeconds(now);
            this.lastTimestamp = QueryIdGenerator.formatEpochMilli(now);
            if (TimeUnit.MILLISECONDS.toDays(now) != this.lastTimeInDays) {
                this.lastTimeInDays = TimeUnit.MILLISECONDS.toDays(now);
                this.counter = 0;
            }
            if (this.counter >= 90000) {
                this.counter = 0;
            }
        }
        long index = this.counter;
        ++this.counter;
        return new QueryId(String.format("%s_%05d_%s", this.lastTimestamp, index, this.dataNodeId));
    }

    private static String formatEpochMilli(long milli) {
        return TIMESTAMP_FORMAT.format(Instant.ofEpochMilli(milli));
    }

    protected long nowInMillis() {
        return BASE_SYSTEM_TIME_MILLIS + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - BASE_NANO_TIME);
    }
}

