/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mtree.store.disk.schemafile;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.db.exception.metadata.schemafile.RecordDuplicatedException;
import org.apache.iotdb.db.exception.metadata.schemafile.SegmentOverflowException;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mtree.store.disk.schemafile.ISegment;
import org.apache.iotdb.db.metadata.mtree.store.disk.schemafile.RecordUtils;
import org.apache.iotdb.db.metadata.mtree.store.disk.schemafile.SchemaFileConfig;
import org.apache.iotdb.db.metadata.mtree.store.disk.schemafile.Segment;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class WrappedSegment
extends Segment<IMNode> {
    private List<Pair<String, String>> aliasKeyList;

    public WrappedSegment(ByteBuffer buffer, boolean override) throws RecordDuplicatedException {
        super(buffer, override);
        if (override) {
            this.aliasKeyList = new ArrayList<Pair<String, String>>();
        } else {
            this.reconstructAliasAddressList();
        }
    }

    public WrappedSegment(ByteBuffer buffer) throws RecordDuplicatedException {
        this(buffer, true);
    }

    public WrappedSegment(int size) throws RecordDuplicatedException {
        this(ByteBuffer.allocate(size));
    }

    public static ISegment<ByteBuffer, IMNode> initAsSegment(ByteBuffer buffer) throws RecordDuplicatedException {
        if (buffer == null) {
            return null;
        }
        return new WrappedSegment(buffer, true);
    }

    public static ISegment<ByteBuffer, IMNode> loadAsSegment(ByteBuffer buffer) throws RecordDuplicatedException {
        if (buffer == null) {
            return null;
        }
        return new WrappedSegment(buffer, false);
    }

    private void reconstructAliasAddressList() throws RecordDuplicatedException {
        if (this.aliasKeyList != null) {
            this.aliasKeyList.clear();
        } else {
            this.aliasKeyList = new ArrayList<Pair<String, String>>();
        }
        ByteBuffer bufferR = this.buffer.asReadOnlyBuffer();
        bufferR.clear();
        for (Pair p : this.keyAddressList) {
            if ((Short)p.right < 0) continue;
            bufferR.position(((Short)p.right).shortValue());
            String alias = RecordUtils.getRecordAlias(bufferR);
            if (alias == null) continue;
            this.aliasKeyList.add(WrappedSegment.binaryInsertPairList(this.aliasKeyList, alias), (Pair<String, String>)new Pair((Object)alias, (Object)((String)p.left)));
        }
    }

    @Override
    public synchronized int insertRecord(String key, ByteBuffer buf) throws RecordDuplicatedException {
        buf.clear();
        int recordStartAddr = this.freeAddr - buf.capacity();
        int newPairLength = this.pairLength + key.getBytes().length + 4 + 2;
        if (recordStartAddr < 25 + newPairLength) {
            return -1;
        }
        this.pairLength = (short)newPairLength;
        int tarIdx = WrappedSegment.binaryInsertPairList(this.keyAddressList, key);
        String alias = RecordUtils.getRecordAlias(buf);
        if (alias != null && !alias.equals("")) {
            this.aliasKeyList.add(WrappedSegment.binaryInsertPairList(this.aliasKeyList, alias), (Pair<String, String>)new Pair((Object)alias, (Object)key));
        }
        buf.clear();
        this.buffer.clear();
        this.buffer.position(recordStartAddr);
        this.buffer.put(buf);
        this.keyAddressList.add(tarIdx, new Pair((Object)key, (Object)((short)recordStartAddr)));
        this.freeAddr = (short)recordStartAddr;
        this.recordNum = (short)(this.recordNum + 1);
        this.penuKey = this.lastKey;
        this.lastKey = key;
        return recordStartAddr - this.pairLength - 25;
    }

    @Override
    public synchronized String splitByKey(String key, ByteBuffer recBuf, ByteBuffer dstBuffer, boolean inclineSplit) throws MetadataException {
        String sk = super.splitByKey(key, recBuf, dstBuffer, inclineSplit);
        this.reconstructAliasAddressList();
        return sk;
    }

    @Override
    public IMNode getRecordByKey(String key) throws MetadataException {
        int index = this.getRecordIndexByKey(key);
        if (index < 0) {
            return null;
        }
        ByteBuffer roBuffer = this.buffer.asReadOnlyBuffer();
        short offset = this.getOffsetByKeyIndex(index);
        roBuffer.clear();
        roBuffer.position(offset);
        short len = RecordUtils.getRecordLength(roBuffer);
        roBuffer.limit(offset + len);
        return RecordUtils.buffer2Node((String)((Pair)this.keyAddressList.get((int)index)).left, roBuffer);
    }

    @Override
    public IMNode getRecordByAlias(String alias) throws MetadataException {
        int ix = this.getRecordIndexByAlias(alias);
        if (ix < 0) {
            return null;
        }
        ByteBuffer rBuffer = this.buffer.asReadOnlyBuffer();
        short offset = this.getOffsetByKeyIndex(ix);
        rBuffer.clear().position(offset).limit(offset + RecordUtils.getRecordLength(rBuffer));
        return RecordUtils.buffer2Node((String)((Pair)this.keyAddressList.get((int)ix)).left, rBuffer);
    }

    @Override
    public boolean hasRecordAlias(String alias) {
        return this.getRecordIndexByAlias(alias) > -1;
    }

    @Override
    public Queue<IMNode> getAllRecords() throws MetadataException {
        ArrayDeque<IMNode> res = new ArrayDeque<IMNode>(this.keyAddressList.size());
        ByteBuffer roBuffer = this.buffer.asReadOnlyBuffer();
        roBuffer.clear();
        for (Pair p : this.keyAddressList) {
            roBuffer.limit(roBuffer.capacity());
            roBuffer.position(((Short)p.right).shortValue());
            short len = RecordUtils.getRecordLength(roBuffer);
            roBuffer.limit((Short)p.right + len);
            res.add(RecordUtils.buffer2Node((String)p.left, roBuffer));
        }
        return res;
    }

    @Override
    public int updateRecord(String key, ByteBuffer uBuffer) throws SegmentOverflowException, RecordDuplicatedException {
        int idx = this.getRecordIndexByKey(key);
        if (idx < 0) {
            return -1;
        }
        this.buffer.clear();
        uBuffer.clear();
        this.buffer.position(((Short)((Pair)this.keyAddressList.get((int)idx)).right).shortValue());
        String oriAlias = RecordUtils.getRecordAlias(this.buffer);
        short oriLen = RecordUtils.getRecordLength(this.buffer);
        short newLen = (short)uBuffer.capacity();
        if (oriLen >= newLen) {
            this.buffer.limit(this.buffer.position() + oriLen);
            this.buffer.put(uBuffer);
        } else {
            if (25 + this.pairLength + newLen > this.freeAddr) {
                throw new SegmentOverflowException(idx);
            }
            this.freeAddr = (short)(this.freeAddr - newLen);
            this.buffer.position(this.freeAddr);
            this.buffer.limit(this.freeAddr + newLen);
            ((Pair)this.keyAddressList.get((int)idx)).right = this.freeAddr;
            this.buffer.put(uBuffer);
        }
        if (oriAlias != null) {
            this.aliasKeyList.remove(WrappedSegment.binarySearchPairList(this.aliasKeyList, oriAlias));
            uBuffer.clear();
            String alias = RecordUtils.getRecordAlias(uBuffer);
            if (alias != null) {
                this.aliasKeyList.add(WrappedSegment.binaryInsertPairList(this.aliasKeyList, alias), (Pair<String, String>)new Pair((Object)alias, (Object)key));
            }
        }
        return idx;
    }

    @Override
    public int removeRecord(String key) {
        String alias;
        int idx = this.getRecordIndexByKey(key);
        if (idx < 0) {
            return -1;
        }
        this.buffer.clear();
        this.buffer.position(((Short)((Pair)this.keyAddressList.get((int)idx)).right).shortValue());
        if ((Short)((Pair)this.keyAddressList.get((int)idx)).right == this.freeAddr) {
            short len = RecordUtils.getRecordLength(this.buffer);
            this.freeAddr = (short)(this.freeAddr + len);
        }
        if ((alias = RecordUtils.getRecordAlias(this.buffer)) != null && !alias.equals("")) {
            this.aliasKeyList.remove(WrappedSegment.binarySearchPairList(this.aliasKeyList, alias));
        }
        this.recordNum = (short)(this.recordNum - 1);
        this.pairLength = (short)(this.pairLength - 2);
        this.pairLength = (short)(this.pairLength - (key.getBytes().length + 4));
        this.keyAddressList.remove(idx);
        return idx;
    }

    @Override
    protected short getRecordLength() {
        return RecordUtils.getRecordLength(this.buffer);
    }

    protected void updateRecordSegAddr(String key, long newSegAddr) {
        int index = this.getRecordIndexByKey(key);
        short offset = this.getOffsetByKeyIndex(index);
        this.buffer.clear();
        this.buffer.position(offset);
        RecordUtils.updateSegAddr(this.buffer, newSegAddr);
    }

    private int getRecordIndexByKey(String key) {
        return WrappedSegment.binarySearchPairList(this.keyAddressList, key);
    }

    private int getRecordIndexByAlias(String alias) {
        int aliasIndex = WrappedSegment.binarySearchPairList(this.aliasKeyList, alias);
        if (aliasIndex < 0) {
            return -1;
        }
        return WrappedSegment.binarySearchPairList(this.keyAddressList, (String)this.aliasKeyList.get((int)aliasIndex).right);
    }

    private short getOffsetByKeyIndex(int index) {
        return (Short)((Pair)this.keyAddressList.get((int)index)).right;
    }

    @Override
    public String toString() {
        ByteBuffer bufferR = this.buffer.asReadOnlyBuffer();
        StringBuilder builder = new StringBuilder("");
        builder.append(String.format("[size: %d, K-AL size: %d, spare:%d,", this.length, this.keyAddressList.size(), this.freeAddr - this.pairLength - 25));
        bufferR.clear();
        for (Pair pair : this.keyAddressList) {
            bufferR.position(((Short)pair.right).shortValue());
            if (RecordUtils.getRecordType(bufferR) == 0 || RecordUtils.getRecordType(bufferR) == 1) {
                builder.append(String.format("(%s -> %s),", pair.left, RecordUtils.getRecordSegAddr(bufferR) == -1L ? Integer.valueOf(-1) : Long.toHexString(RecordUtils.getRecordSegAddr(bufferR))));
                continue;
            }
            if (RecordUtils.getRecordType(bufferR) == 4) {
                builder.append(String.format("(%s, %s),", pair.left, RecordUtils.getRecordAlias(bufferR)));
                continue;
            }
            throw new BufferUnderflowException();
        }
        builder.append("]");
        return builder.toString();
    }

    @Override
    public String inspect() {
        if (!SchemaFileConfig.DETAIL_SKETCH) {
            return "";
        }
        ByteBuffer bufferR = this.buffer.asReadOnlyBuffer();
        StringBuilder builder = new StringBuilder("");
        builder.append(String.format("[length: %d, total_records: %d, spare_size:%d,", this.length, this.keyAddressList.size(), this.freeAddr - this.pairLength - 25));
        bufferR.clear();
        for (Pair pair : this.keyAddressList) {
            bufferR.position(((Short)pair.right).shortValue());
            if (RecordUtils.getRecordType(bufferR) == 0 || RecordUtils.getRecordType(bufferR) == 1) {
                builder.append(String.format("(%s, %s, %s),", pair.left, RecordUtils.getAlignment(bufferR) ? "aligned" : "not_aligned", RecordUtils.getRecordSegAddr(bufferR) == -1L ? Integer.valueOf(-1) : Long.toHexString(RecordUtils.getRecordSegAddr(bufferR))));
                continue;
            }
            if (RecordUtils.getRecordType(bufferR) == 4) {
                byte[] schemaBytes = RecordUtils.getMeasStatsBytes(bufferR);
                builder.append(String.format("(%s, %s, %s, %s, %s),", pair.left, TSDataType.values()[schemaBytes[0]], TSEncoding.values()[schemaBytes[1]], CompressionType.deserialize((byte)schemaBytes[2]), RecordUtils.getRecordAlias(bufferR)));
                continue;
            }
            throw new BufferUnderflowException();
        }
        builder.append("]");
        return builder.toString();
    }

    static short getSegBufLen(ByteBuffer buffer) {
        short res = ReadWriteIOUtils.readShort((ByteBuffer)buffer);
        buffer.position(buffer.position() - 2);
        return res;
    }

    public ByteBuffer getBufferCopy() {
        this.syncBuffer();
        ByteBuffer newBuffer = ByteBuffer.allocate(this.buffer.capacity());
        this.buffer.clear();
        newBuffer.put(this.buffer);
        newBuffer.clear();
        return newBuffer;
    }

    public ByteBuffer getRecord(String key) {
        int idx = this.getRecordIndexByKey(key);
        if (idx >= 0) {
            short targetAddr = (Short)((Pair)this.keyAddressList.get((int)idx)).right;
            this.buffer.clear();
            this.buffer.position(targetAddr);
            short len = RecordUtils.getRecordLength(this.buffer);
            this.buffer.limit(targetAddr + len);
            return this.buffer.slice();
        }
        return null;
    }

    public List<Pair<String, Short>> getKeyOffsetList() {
        return this.keyAddressList;
    }
}

