/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mnode;

import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mnode.MNode;
import org.apache.iotdb.db.metadata.mnode.MNodeType;
import org.apache.iotdb.db.metadata.mnode.container.IMNodeContainer;
import org.apache.iotdb.db.metadata.mnode.container.MNodeContainers;
import org.apache.iotdb.db.metadata.mnode.visitor.MNodeVisitor;

public class InternalMNode
extends MNode {
    private static final long serialVersionUID = -770028375899514063L;
    protected volatile transient IMNodeContainer children = null;
    protected int schemaTemplateId = -1;
    private volatile boolean useTemplate = false;

    public InternalMNode(IMNode parent, String name) {
        super(parent, name);
    }

    @Override
    public boolean hasChild(String name) {
        return this.children != null && this.children.containsKey(name);
    }

    @Override
    public IMNode getChild(String name) {
        IMNode child = null;
        if (this.children != null) {
            child = (IMNode)this.children.get(name);
        }
        return child;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IMNode addChild(String name, IMNode child) {
        if (this.children == null) {
            InternalMNode internalMNode = this;
            synchronized (internalMNode) {
                if (this.children == null) {
                    this.children = MNodeContainers.getNewMNodeContainer();
                }
            }
        }
        child.setParent(this);
        IMNode existingChild = this.children.putIfAbsent(name, child);
        return existingChild == null ? child : existingChild;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IMNode addChild(IMNode child) {
        if (this.children == null) {
            InternalMNode internalMNode = this;
            synchronized (internalMNode) {
                if (this.children == null) {
                    this.children = MNodeContainers.getNewMNodeContainer();
                }
            }
        }
        child.setParent(this);
        this.children.putIfAbsent(child.getName(), child);
        return child;
    }

    @Override
    public IMNode deleteChild(String name) {
        if (this.children != null) {
            return (IMNode)this.children.remove(name);
        }
        return null;
    }

    @Override
    public synchronized void replaceChild(String oldChildName, IMNode newChildNode) {
        if (!oldChildName.equals(newChildNode.getName())) {
            throw new RuntimeException("New child's name must be the same as old child's name!");
        }
        IMNode oldChildNode = this.getChild(oldChildName);
        if (oldChildNode == null) {
            return;
        }
        oldChildNode.moveDataToNewMNode(newChildNode);
        this.children.replace(newChildNode.getName(), newChildNode);
    }

    @Override
    public void moveDataToNewMNode(IMNode newMNode) {
        super.moveDataToNewMNode(newMNode);
        newMNode.setUseTemplate(this.useTemplate);
        newMNode.setSchemaTemplateId(this.schemaTemplateId);
        if (this.children != null) {
            newMNode.setChildren(this.children);
            this.children.forEach((childName, childNode) -> childNode.setParent(newMNode));
        }
    }

    @Override
    public IMNodeContainer getChildren() {
        if (this.children == null) {
            return MNodeContainers.emptyMNodeContainer();
        }
        return this.children;
    }

    @Override
    public void setChildren(IMNodeContainer children) {
        this.children = children;
    }

    @Override
    public int getSchemaTemplateId() {
        return this.schemaTemplateId >= -1 ? this.schemaTemplateId : -this.schemaTemplateId - 2;
    }

    @Override
    public int getSchemaTemplateIdWithState() {
        return this.schemaTemplateId;
    }

    @Override
    public void setSchemaTemplateId(int schemaTemplateId) {
        this.schemaTemplateId = schemaTemplateId;
    }

    @Override
    public void preUnsetSchemaTemplate() {
        if (this.schemaTemplateId > -1) {
            this.schemaTemplateId = -this.schemaTemplateId - 2;
        }
    }

    @Override
    public void rollbackUnsetSchemaTemplate() {
        if (this.schemaTemplateId < -1) {
            this.schemaTemplateId = -this.schemaTemplateId - 2;
        }
    }

    @Override
    public boolean isSchemaTemplatePreUnset() {
        return this.schemaTemplateId < -1;
    }

    @Override
    public void unsetSchemaTemplate() {
        this.schemaTemplateId = -1;
    }

    @Override
    public boolean isAboveDatabase() {
        return false;
    }

    @Override
    public MNodeType getMNodeType(Boolean isConfig) {
        return isConfig != false ? MNodeType.SG_INTERNAL : MNodeType.INTERNAL;
    }

    @Override
    public boolean isUseTemplate() {
        return this.useTemplate;
    }

    @Override
    public void setUseTemplate(boolean useTemplate) {
        this.useTemplate = useTemplate;
    }

    @Override
    public <R, C> R accept(MNodeVisitor<R, C> visitor, C context) {
        return visitor.visitInternalMNode(this, context);
    }
}

