/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.trigger.utils;

import java.util.ArrayList;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.trigger.sink.api.Event;
import org.apache.iotdb.db.engine.trigger.sink.api.Handler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchHandlerQueue<T extends Event> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BatchHandlerQueue.class);
    private final int queueNumber;
    private final int queueSize;
    private final int batchSize;
    private final AtomicInteger atomicCount = new AtomicInteger();
    private final ArrayBlockingQueue<T>[] queues;
    private final Handler handler;

    public BatchHandlerQueue(int queueNumber, int queueSize, int batchSize, Handler handler) {
        this.queueNumber = Math.min(queueNumber, IoTDBDescriptor.getInstance().getConfig().getTriggerForwardMaxQueueNumber());
        this.queueSize = Math.min(queueSize, IoTDBDescriptor.getInstance().getConfig().getTriggerForwardMaxSizePerQueue());
        this.batchSize = Math.min(batchSize, IoTDBDescriptor.getInstance().getConfig().getTriggerForwardBatchSize());
        this.handler = handler;
        this.queues = new ArrayBlockingQueue[this.queueNumber];
        for (int i = 0; i < queueNumber; ++i) {
            this.queues[i] = new ArrayBlockingQueue(this.queueSize);
            ForwardQueueConsumer t = new ForwardQueueConsumer(handler.getClass().getSimpleName() + "-" + BatchHandlerQueue.class.getSimpleName() + "-" + i, this.queues[i]);
            t.setDaemon(true);
            t.start();
        }
    }

    private int getQueueID(int hashCode) {
        return (hashCode & Integer.MAX_VALUE) % this.queues.length;
    }

    public boolean offer(T event) {
        if (event.getFullPath() != null) {
            return this.queues[this.getQueueID(event.getFullPath().getDevice().hashCode())].offer(event);
        }
        return this.queues[this.getQueueID(this.atomicCount.incrementAndGet())].offer(event);
    }

    public void put(T event) throws InterruptedException {
        if (event.getFullPath() != null) {
            this.queues[this.getQueueID(event.getFullPath().getDevice().hashCode())].put(event);
        } else {
            this.queues[this.getQueueID(this.atomicCount.incrementAndGet())].put(event);
        }
    }

    private void handle(ArrayList<T> events) throws Exception {
        this.handler.onEvent(events);
    }

    class ForwardQueueConsumer
    extends Thread {
        ArrayBlockingQueue<T> queue;

        public ForwardQueueConsumer(String name, ArrayBlockingQueue<T> queue) {
            super(name);
            this.queue = queue;
        }

        @Override
        public void run() {
            long maxWaitMillis = 500L;
            ArrayList<Event> list = new ArrayList<Event>();
            long startMillis = System.currentTimeMillis();
            long restMillis = 500L;
            while (true) {
                try {
                    while (true) {
                        Event obj;
                        if ((obj = list.isEmpty() ? (Event)this.queue.take() : (Event)this.queue.poll(restMillis, TimeUnit.MILLISECONDS)) != null) {
                            long waitMillis;
                            list.add(obj);
                            this.queue.drainTo(list, BatchHandlerQueue.this.batchSize - list.size());
                            if (list.size() < BatchHandlerQueue.this.batchSize && (waitMillis = System.currentTimeMillis() - startMillis) < 500L) {
                                restMillis = 500L - waitMillis;
                                continue;
                            }
                        }
                        BatchHandlerQueue.this.handle(list);
                        list.clear();
                        startMillis = System.currentTimeMillis();
                    }
                }
                catch (InterruptedException e) {
                }
                catch (Throwable t) {
                    LOGGER.error("ForwardTaskQueue consumer error", t);
                    continue;
                }
                break;
            }
        }
    }
}

