/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.storagegroup;

import org.apache.iotdb.commons.consensus.DataRegionId;

public class TimePartitionInfo {
    DataRegionId dataRegionId;
    long partitionId;
    boolean isActive;
    long lastSystemFlushTime;
    boolean isLatestPartition;
    long memSize;

    public TimePartitionInfo(DataRegionId dataRegionId, long partitionId, boolean isActive, long lastSystemFlushTime, long memsize, boolean isLatestPartition) {
        this.dataRegionId = dataRegionId;
        this.partitionId = partitionId;
        this.isActive = isActive;
        this.lastSystemFlushTime = lastSystemFlushTime;
        this.memSize = memsize;
        this.isLatestPartition = isLatestPartition;
    }

    public int comparePriority(TimePartitionInfo timePartitionInfo) {
        int cmp = Boolean.compare(this.isActive, timePartitionInfo.isActive);
        if (cmp != 0) {
            return cmp;
        }
        cmp = Boolean.compare(this.isLatestPartition, timePartitionInfo.isLatestPartition);
        if (cmp != 0) {
            return cmp;
        }
        return Long.compare(this.lastSystemFlushTime, timePartitionInfo.lastSystemFlushTime);
    }
}

