/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.memtable;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.iotdb.db.engine.memtable.IWritableMemChunk;
import org.apache.iotdb.db.utils.datastructure.TVList;
import org.apache.iotdb.db.wal.buffer.IWALByteBufferView;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.BitMap;
import org.apache.iotdb.tsfile.write.chunk.ChunkWriterImpl;
import org.apache.iotdb.tsfile.write.chunk.IChunkWriter;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WritableMemChunk
implements IWritableMemChunk {
    private IMeasurementSchema schema;
    private TVList list;
    private static final String UNSUPPORTED_TYPE = "Unsupported data type:";
    private static final Logger LOGGER = LoggerFactory.getLogger(WritableMemChunk.class);

    public WritableMemChunk(IMeasurementSchema schema) {
        this.schema = schema;
        this.list = TVList.newList(schema.getType());
    }

    private WritableMemChunk() {
    }

    @Override
    public boolean writeWithFlushCheck(long insertTime, Object objectValue) {
        switch (this.schema.getType()) {
            case BOOLEAN: {
                this.putBoolean(insertTime, (Boolean)objectValue);
                break;
            }
            case INT32: {
                this.putInt(insertTime, (Integer)objectValue);
                break;
            }
            case INT64: {
                this.putLong(insertTime, (Long)objectValue);
                break;
            }
            case FLOAT: {
                this.putFloat(insertTime, ((Float)objectValue).floatValue());
                break;
            }
            case DOUBLE: {
                this.putDouble(insertTime, (Double)objectValue);
                break;
            }
            case TEXT: {
                return this.putBinaryWithFlushCheck(insertTime, (Binary)objectValue);
            }
            default: {
                throw new UnSupportedDataTypeException(UNSUPPORTED_TYPE + this.schema.getType());
            }
        }
        return false;
    }

    @Override
    public boolean writeAlignedValueWithFlushCheck(long insertTime, Object[] objectValue, List<IMeasurementSchema> schemaList) {
        throw new UnSupportedDataTypeException(UNSUPPORTED_TYPE + this.list.getDataType());
    }

    @Override
    public boolean writeWithFlushCheck(long[] times, Object valueList, BitMap bitMap, TSDataType dataType, int start, int end) {
        switch (dataType) {
            case BOOLEAN: {
                boolean[] boolValues = (boolean[])valueList;
                this.putBooleans(times, boolValues, bitMap, start, end);
                break;
            }
            case INT32: {
                int[] intValues = (int[])valueList;
                this.putInts(times, intValues, bitMap, start, end);
                break;
            }
            case INT64: {
                long[] longValues = (long[])valueList;
                this.putLongs(times, longValues, bitMap, start, end);
                break;
            }
            case FLOAT: {
                float[] floatValues = (float[])valueList;
                this.putFloats(times, floatValues, bitMap, start, end);
                break;
            }
            case DOUBLE: {
                double[] doubleValues = (double[])valueList;
                this.putDoubles(times, doubleValues, bitMap, start, end);
                break;
            }
            case TEXT: {
                Binary[] binaryValues = (Binary[])valueList;
                return this.putBinariesWithFlushCheck(times, binaryValues, bitMap, start, end);
            }
            default: {
                throw new UnSupportedDataTypeException(UNSUPPORTED_TYPE + dataType);
            }
        }
        return false;
    }

    @Override
    public boolean writeAlignedValuesWithFlushCheck(long[] times, Object[] valueList, BitMap[] bitMaps, List<IMeasurementSchema> schemaList, int start, int end) {
        throw new UnSupportedDataTypeException(UNSUPPORTED_TYPE + this.list.getDataType());
    }

    @Override
    public void putLong(long t, long v) {
        this.list.putLong(t, v);
    }

    @Override
    public void putInt(long t, int v) {
        this.list.putInt(t, v);
    }

    @Override
    public void putFloat(long t, float v) {
        this.list.putFloat(t, v);
    }

    @Override
    public void putDouble(long t, double v) {
        this.list.putDouble(t, v);
    }

    @Override
    public boolean putBinaryWithFlushCheck(long t, Binary v) {
        this.list.putBinary(t, v);
        return this.list.reachMaxChunkSizeThreshold();
    }

    @Override
    public void putBoolean(long t, boolean v) {
        this.list.putBoolean(t, v);
    }

    @Override
    public boolean putAlignedValueWithFlushCheck(long t, Object[] v, int[] columnIndexArray) {
        throw new UnSupportedDataTypeException(UNSUPPORTED_TYPE + this.schema.getType());
    }

    @Override
    public void putLongs(long[] t, long[] v, BitMap bitMap, int start, int end) {
        this.list.putLongs(t, v, bitMap, start, end);
    }

    @Override
    public void putInts(long[] t, int[] v, BitMap bitMap, int start, int end) {
        this.list.putInts(t, v, bitMap, start, end);
    }

    @Override
    public void putFloats(long[] t, float[] v, BitMap bitMap, int start, int end) {
        this.list.putFloats(t, v, bitMap, start, end);
    }

    @Override
    public void putDoubles(long[] t, double[] v, BitMap bitMap, int start, int end) {
        this.list.putDoubles(t, v, bitMap, start, end);
    }

    @Override
    public boolean putBinariesWithFlushCheck(long[] t, Binary[] v, BitMap bitMap, int start, int end) {
        this.list.putBinaries(t, v, bitMap, start, end);
        return this.list.reachMaxChunkSizeThreshold();
    }

    @Override
    public void putBooleans(long[] t, boolean[] v, BitMap bitMap, int start, int end) {
        this.list.putBooleans(t, v, bitMap, start, end);
    }

    @Override
    public boolean putAlignedValuesWithFlushCheck(long[] t, Object[] v, BitMap[] bitMaps, int[] columnIndexArray, int start, int end) {
        throw new UnSupportedDataTypeException(UNSUPPORTED_TYPE + this.schema.getType());
    }

    @Override
    public synchronized TVList getSortedTvListForQuery() {
        this.sortTVList();
        this.list.increaseReferenceCount();
        return this.list;
    }

    @Override
    public synchronized TVList getSortedTvListForQuery(List<IMeasurementSchema> measurementSchema) {
        throw new UnSupportedDataTypeException(UNSUPPORTED_TYPE + this.list.getDataType());
    }

    private void sortTVList() {
        if (this.list.getReferenceCount() > 0 && !this.list.isSorted()) {
            this.list = this.list.clone();
        }
        if (!this.list.isSorted()) {
            this.list.sort();
        }
    }

    @Override
    public synchronized void sortTvListForFlush() {
        this.sortTVList();
    }

    @Override
    public TVList getTVList() {
        return this.list;
    }

    @Override
    public long count() {
        return this.list.rowCount();
    }

    @Override
    public IMeasurementSchema getSchema() {
        return this.schema;
    }

    @Override
    public long getMaxTime() {
        return this.list.getMaxTime();
    }

    @Override
    public long getFirstPoint() {
        if (this.list.rowCount() == 0) {
            return Long.MAX_VALUE;
        }
        return this.getSortedTvListForQuery().getTimeValuePair(0).getTimestamp();
    }

    @Override
    public long getLastPoint() {
        if (this.list.rowCount() == 0) {
            return Long.MIN_VALUE;
        }
        return this.getSortedTvListForQuery().getTimeValuePair(this.getSortedTvListForQuery().rowCount() - 1).getTimestamp();
    }

    @Override
    public boolean isEmpty() {
        return this.list.rowCount() == 0;
    }

    @Override
    public int delete(long lowerBound, long upperBound) {
        return this.list.delete(lowerBound, upperBound);
    }

    @Override
    public IChunkWriter createIChunkWriter() {
        return new ChunkWriterImpl(this.schema);
    }

    public String toString() {
        int size = this.list.rowCount();
        int firstIndex = 0;
        int lastIndex = size - 1;
        long minTime = Long.MAX_VALUE;
        long maxTime = Long.MIN_VALUE;
        for (int i = 0; i < size; ++i) {
            long currentTime = this.list.getTime(i);
            if (currentTime < minTime) {
                firstIndex = i;
                minTime = currentTime;
            }
            if (currentTime < maxTime) continue;
            lastIndex = i;
            maxTime = currentTime;
        }
        StringBuilder out = new StringBuilder("MemChunk Size: " + size + System.lineSeparator());
        if (size != 0) {
            out.append("Data type:").append(this.schema.getType()).append(System.lineSeparator());
            out.append("First point:").append(this.list.getTimeValuePair(firstIndex)).append(System.lineSeparator());
            out.append("Last point:").append(this.list.getTimeValuePair(lastIndex)).append(System.lineSeparator());
        }
        return out.toString();
    }

    @Override
    public void encode(IChunkWriter chunkWriter) {
        ChunkWriterImpl chunkWriterImpl = (ChunkWriterImpl)chunkWriter;
        block8: for (int sortedRowIndex = 0; sortedRowIndex < this.list.rowCount(); ++sortedRowIndex) {
            long time = this.list.getTime(sortedRowIndex);
            if (sortedRowIndex + 1 < this.list.rowCount() && time == this.list.getTime(sortedRowIndex + 1)) continue;
            if (sortedRowIndex + 1 == this.list.rowCount()) {
                chunkWriterImpl.setLastPoint(true);
            }
            switch (this.schema.getType()) {
                case BOOLEAN: {
                    chunkWriterImpl.write(time, this.list.getBoolean(sortedRowIndex));
                    continue block8;
                }
                case INT32: {
                    chunkWriterImpl.write(time, this.list.getInt(sortedRowIndex));
                    continue block8;
                }
                case INT64: {
                    chunkWriterImpl.write(time, this.list.getLong(sortedRowIndex));
                    continue block8;
                }
                case FLOAT: {
                    chunkWriterImpl.write(time, this.list.getFloat(sortedRowIndex));
                    continue block8;
                }
                case DOUBLE: {
                    chunkWriterImpl.write(time, this.list.getDouble(sortedRowIndex));
                    continue block8;
                }
                case TEXT: {
                    chunkWriterImpl.write(time, this.list.getBinary(sortedRowIndex));
                    continue block8;
                }
                default: {
                    LOGGER.error("WritableMemChunk does not support data type: {}", (Object)this.schema.getType());
                }
            }
        }
    }

    @Override
    public void release() {
        if (this.list.getReferenceCount() == 0) {
            this.list.clear();
        }
    }

    @Override
    public int serializedSize() {
        return this.schema.serializedSize() + this.list.serializedSize();
    }

    @Override
    public void serializeToWAL(IWALByteBufferView buffer) {
        byte[] bytes = new byte[this.schema.serializedSize()];
        this.schema.serializeTo(ByteBuffer.wrap(bytes));
        buffer.put(bytes);
        this.list.serializeToWAL(buffer);
    }

    public static WritableMemChunk deserialize(DataInputStream stream) throws IOException {
        WritableMemChunk memChunk = new WritableMemChunk();
        memChunk.schema = MeasurementSchema.deserializeFrom((InputStream)stream);
        memChunk.list = TVList.deserialize(stream);
        return memChunk;
    }
}

