/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.load;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.db.engine.load.ChunkData;
import org.apache.iotdb.db.utils.TimePartitionUtils;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.exception.write.PageException;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.header.ChunkHeader;
import org.apache.iotdb.tsfile.file.header.PageHeader;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.Chunk;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.PublicBAOS;
import org.apache.iotdb.tsfile.utils.ReadWriteForEncodingUtils;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;
import org.apache.iotdb.tsfile.write.chunk.AlignedChunkWriterImpl;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.apache.iotdb.tsfile.write.writer.TsFileIOWriter;

public class AlignedChunkData
implements ChunkData {
    private static final int DEFAULT_INT32 = 0;
    private static final long DEFAULT_INT64 = 0L;
    private static final float DEFAULT_FLOAT = 0.0f;
    private static final double DEFAULT_DOUBLE = 0.0;
    private static final boolean DEFAULT_BOOLEAN = false;
    private static final Binary DEFAULT_BINARY = null;
    private final TTimePartitionSlot timePartitionSlot;
    private final String device;
    private List<ChunkHeader> chunkHeaderList;
    private final PublicBAOS byteStream;
    private final DataOutputStream stream;
    private List<long[]> timeBatch;
    private long dataSize = 0L;
    private boolean needDecodeChunk;
    private List<Integer> pageNumbers;
    private Queue<Integer> satisfiedLengthQueue;
    private AlignedChunkWriterImpl chunkWriter;
    private List<Chunk> chunkList;

    public AlignedChunkData(String device, ChunkHeader chunkHeader, TTimePartitionSlot timePartitionSlot) {
        this.device = device;
        this.chunkHeaderList = new ArrayList<ChunkHeader>();
        this.timePartitionSlot = timePartitionSlot;
        this.needDecodeChunk = true;
        this.pageNumbers = new ArrayList<Integer>();
        this.satisfiedLengthQueue = new LinkedList<Integer>();
        this.byteStream = new PublicBAOS();
        this.stream = new DataOutputStream((OutputStream)this.byteStream);
        this.chunkHeaderList.add(chunkHeader);
        this.pageNumbers.add(0);
        this.addAttrDataSize();
    }

    private void addAttrDataSize() {
        this.dataSize += 2L;
        this.dataSize += 8L;
        int deviceLength = this.device.getBytes(TSFileConfig.STRING_CHARSET).length;
        this.dataSize += (long)ReadWriteForEncodingUtils.varIntSize((int)deviceLength);
        this.dataSize += (long)deviceLength;
        this.dataSize += 4L;
        this.dataSize += (long)this.chunkHeaderList.get(0).getSerializedSize();
    }

    @Override
    public String getDevice() {
        return this.device;
    }

    @Override
    public TTimePartitionSlot getTimePartitionSlot() {
        return this.timePartitionSlot;
    }

    @Override
    public long getDataSize() {
        return this.dataSize;
    }

    @Override
    public void setNotDecode() {
        this.needDecodeChunk = false;
    }

    @Override
    public boolean isAligned() {
        return true;
    }

    @Override
    public void writeToFileWriter(TsFileIOWriter writer) throws IOException {
        if (this.chunkList != null) {
            for (Chunk chunk : this.chunkList) {
                writer.writeChunk(chunk);
            }
        } else {
            this.chunkWriter.writeToFileWriter(writer);
        }
    }

    public void addValueChunk(ChunkHeader chunkHeader) {
        this.chunkHeaderList.add(chunkHeader);
        this.pageNumbers.add(0);
        this.dataSize += (long)chunkHeader.getSerializedSize();
        if (this.needDecodeChunk) {
            this.dataSize += 4L;
        }
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((Boolean)this.isModification(), (OutputStream)stream);
        ReadWriteIOUtils.write((Boolean)this.isAligned(), (OutputStream)stream);
        this.serializeAttr(stream);
        this.byteStream.writeTo((OutputStream)stream);
        this.close();
    }

    private void serializeAttr(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((long)this.timePartitionSlot.getStartTime(), (OutputStream)stream);
        ReadWriteIOUtils.write((String)this.device, (OutputStream)stream);
        ReadWriteIOUtils.write((Boolean)this.needDecodeChunk, (OutputStream)stream);
        ReadWriteIOUtils.write((int)this.chunkHeaderList.size(), (OutputStream)stream);
        for (ChunkHeader chunkHeader : this.chunkHeaderList) {
            chunkHeader.serializeTo((OutputStream)stream);
        }
        if (this.needDecodeChunk) {
            for (Integer pageNumber : this.pageNumbers) {
                ReadWriteIOUtils.write((int)pageNumber, (OutputStream)stream);
            }
        }
    }

    @Override
    public void writeEntireChunk(ByteBuffer chunkData, IChunkMetadata chunkMetadata) throws IOException {
        this.dataSize += (long)ReadWriteIOUtils.write((ByteBuffer)chunkData, (OutputStream)this.stream);
        this.dataSize += (long)chunkMetadata.getStatistics().serialize((OutputStream)this.stream);
    }

    @Override
    public void writeEntirePage(PageHeader pageHeader, ByteBuffer pageData) throws IOException {
        this.pageNumbers.set(this.pageNumbers.size() - 1, this.pageNumbers.get(this.pageNumbers.size() - 1) + 1);
        this.dataSize += (long)ReadWriteIOUtils.write((Boolean)false, (OutputStream)this.stream);
        this.dataSize += (long)pageHeader.serializeTo((OutputStream)this.stream);
        this.dataSize += (long)ReadWriteIOUtils.write((ByteBuffer)pageData, (OutputStream)this.stream);
    }

    @Override
    public void writeDecodePage(long[] times, Object[] values, int satisfiedLength) throws IOException {
        this.pageNumbers.set(this.pageNumbers.size() - 1, this.pageNumbers.get(this.pageNumbers.size() - 1) + 1);
        this.satisfiedLengthQueue.offer(satisfiedLength);
        long startTime = this.timePartitionSlot.getStartTime();
        long endTime = startTime + TimePartitionUtils.getTimePartitionInterval();
        this.dataSize += (long)ReadWriteIOUtils.write((Boolean)true, (OutputStream)this.stream);
        this.dataSize += (long)ReadWriteIOUtils.write((int)satisfiedLength, (OutputStream)this.stream);
        for (int i = 0; i < times.length; ++i) {
            if (times[i] < startTime) continue;
            if (times[i] >= endTime) break;
            this.dataSize += (long)ReadWriteIOUtils.write((long)times[i], (OutputStream)this.stream);
        }
    }

    public void writeDecodeValuePage(long[] times, TsPrimitiveType[] values, TSDataType dataType) throws IOException {
        this.pageNumbers.set(this.pageNumbers.size() - 1, this.pageNumbers.get(this.pageNumbers.size() - 1) + 1);
        long startTime = this.timePartitionSlot.getStartTime();
        long endTime = startTime + TimePartitionUtils.getTimePartitionInterval();
        int satisfiedLength = this.satisfiedLengthQueue.poll();
        this.dataSize += (long)ReadWriteIOUtils.write((Boolean)true, (OutputStream)this.stream);
        this.dataSize += (long)ReadWriteIOUtils.write((int)satisfiedLength, (OutputStream)this.stream);
        this.satisfiedLengthQueue.offer(satisfiedLength);
        block8: for (int i = 0; i < times.length; ++i) {
            if (times[i] < startTime) continue;
            if (times[i] >= endTime) break;
            if (values.length == 0 || values[i] == null) {
                this.dataSize += (long)ReadWriteIOUtils.write((Boolean)true, (OutputStream)this.stream);
                continue;
            }
            this.dataSize += (long)ReadWriteIOUtils.write((Boolean)false, (OutputStream)this.stream);
            switch (dataType) {
                case INT32: {
                    this.dataSize += (long)ReadWriteIOUtils.write((int)values[i].getInt(), (OutputStream)this.stream);
                    continue block8;
                }
                case INT64: {
                    this.dataSize += (long)ReadWriteIOUtils.write((long)values[i].getLong(), (OutputStream)this.stream);
                    continue block8;
                }
                case FLOAT: {
                    this.dataSize += (long)ReadWriteIOUtils.write((float)values[i].getFloat(), (OutputStream)this.stream);
                    continue block8;
                }
                case DOUBLE: {
                    this.dataSize += (long)ReadWriteIOUtils.write((double)values[i].getDouble(), (OutputStream)this.stream);
                    continue block8;
                }
                case BOOLEAN: {
                    this.dataSize += (long)ReadWriteIOUtils.write((Boolean)values[i].getBoolean(), (OutputStream)this.stream);
                    continue block8;
                }
                case TEXT: {
                    this.dataSize += (long)ReadWriteIOUtils.write((Binary)values[i].getBinary(), (OutputStream)this.stream);
                    continue block8;
                }
                default: {
                    throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", dataType));
                }
            }
        }
    }

    private void deserializeTsFileData(InputStream stream) throws IOException, PageException {
        if (this.needDecodeChunk) {
            this.buildChunkWriter(stream);
        } else {
            this.deserializeEntireChunk(stream);
        }
    }

    private void deserializeEntireChunk(InputStream stream) throws IOException {
        this.chunkList = new ArrayList<Chunk>();
        int chunkSize = this.chunkHeaderList.size();
        for (int i = 0; i < chunkSize; ++i) {
            ByteBuffer chunkData = ByteBuffer.wrap(ReadWriteIOUtils.readBytesWithSelfDescriptionLength((InputStream)stream));
            Statistics statistics = Statistics.deserialize((InputStream)stream, (TSDataType)this.chunkHeaderList.get(i).getDataType());
            this.chunkList.add(new Chunk(this.chunkHeaderList.get(i), chunkData, null, statistics));
        }
    }

    private void buildChunkWriter(InputStream stream) throws IOException, PageException {
        ArrayList<MeasurementSchema> measurementSchemaList = new ArrayList<MeasurementSchema>();
        for (ChunkHeader chunkHeader : this.chunkHeaderList) {
            if (TSDataType.VECTOR.equals((Object)chunkHeader.getDataType())) continue;
            measurementSchemaList.add(new MeasurementSchema(chunkHeader.getMeasurementID(), chunkHeader.getDataType(), chunkHeader.getEncodingType(), chunkHeader.getCompressionType()));
        }
        this.chunkWriter = new AlignedChunkWriterImpl(measurementSchemaList);
        this.timeBatch = new ArrayList<long[]>();
        int chunkHeaderSize = this.chunkHeaderList.size();
        for (int i = 0; i < chunkHeaderSize; ++i) {
            this.buildChunk(stream, this.chunkHeaderList.get(i), this.pageNumbers.get(i), i - 1, i == 0);
        }
        this.timeBatch = null;
    }

    private void buildChunk(InputStream stream, ChunkHeader chunkHeader, int pageNumber, int valueChunkIndex, boolean isTimeChunk) throws IOException, PageException {
        int decodePageIndex = 0;
        for (int j = 0; j < pageNumber; ++j) {
            boolean needDecode = ReadWriteIOUtils.readBool((InputStream)stream);
            if (needDecode) {
                int length = ReadWriteIOUtils.readInt((InputStream)stream);
                long[] timePageBatch = new long[length];
                if (!isTimeChunk) {
                    timePageBatch = this.timeBatch.get(decodePageIndex);
                }
                block9: for (int i = 0; i < length; ++i) {
                    if (isTimeChunk) {
                        long time;
                        timePageBatch[i] = time = ReadWriteIOUtils.readLong((InputStream)stream);
                        this.chunkWriter.writeTime(time);
                        continue;
                    }
                    boolean isNull = ReadWriteIOUtils.readBool((InputStream)stream);
                    switch (chunkHeader.getDataType()) {
                        case INT32: {
                            int int32Value = isNull ? 0 : ReadWriteIOUtils.readInt((InputStream)stream);
                            this.chunkWriter.write(timePageBatch[i], int32Value, isNull, valueChunkIndex);
                            continue block9;
                        }
                        case INT64: {
                            long int64Value = isNull ? 0L : ReadWriteIOUtils.readLong((InputStream)stream);
                            this.chunkWriter.write(timePageBatch[i], int64Value, isNull, valueChunkIndex);
                            continue block9;
                        }
                        case FLOAT: {
                            float floatValue = isNull ? 0.0f : ReadWriteIOUtils.readFloat((InputStream)stream);
                            this.chunkWriter.write(timePageBatch[i], floatValue, isNull, valueChunkIndex);
                            continue block9;
                        }
                        case DOUBLE: {
                            double doubleValue = isNull ? 0.0 : ReadWriteIOUtils.readDouble((InputStream)stream);
                            this.chunkWriter.write(timePageBatch[i], doubleValue, isNull, valueChunkIndex);
                            continue block9;
                        }
                        case BOOLEAN: {
                            boolean boolValue = isNull ? false : ReadWriteIOUtils.readBool((InputStream)stream);
                            this.chunkWriter.write(timePageBatch[i], boolValue, isNull, valueChunkIndex);
                            continue block9;
                        }
                        case TEXT: {
                            Binary binaryValue = isNull ? DEFAULT_BINARY : ReadWriteIOUtils.readBinary((InputStream)stream);
                            this.chunkWriter.write(timePageBatch[i], binaryValue, isNull, valueChunkIndex);
                            continue block9;
                        }
                        default: {
                            throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", chunkHeader.getDataType()));
                        }
                    }
                }
                if (isTimeChunk) {
                    this.timeBatch.add(timePageBatch);
                }
                ++decodePageIndex;
                if (isTimeChunk) {
                    this.chunkWriter.sealCurrentTimePage();
                    continue;
                }
                this.chunkWriter.sealCurrentValuePage(valueChunkIndex);
                continue;
            }
            PageHeader pageHeader = PageHeader.deserializeFrom((InputStream)stream, (TSDataType)chunkHeader.getDataType(), (boolean)true);
            if (isTimeChunk) {
                this.chunkWriter.writePageHeaderAndDataIntoTimeBuff(ByteBuffer.wrap(ReadWriteIOUtils.readBytesWithSelfDescriptionLength((InputStream)stream)), pageHeader);
                continue;
            }
            this.chunkWriter.writePageHeaderAndDataIntoValueBuff(ByteBuffer.wrap(ReadWriteIOUtils.readBytesWithSelfDescriptionLength((InputStream)stream)), pageHeader, valueChunkIndex);
        }
    }

    public static AlignedChunkData deserialize(InputStream stream) throws IOException, PageException {
        TTimePartitionSlot timePartitionSlot = TimePartitionUtils.getTimePartition(ReadWriteIOUtils.readLong((InputStream)stream));
        String device = ReadWriteIOUtils.readString((InputStream)stream);
        boolean needDecodeChunk = ReadWriteIOUtils.readBool((InputStream)stream);
        int chunkHeaderListSize = ReadWriteIOUtils.readInt((InputStream)stream);
        ArrayList<ChunkHeader> chunkHeaderList = new ArrayList<ChunkHeader>();
        for (int i = 0; i < chunkHeaderListSize; ++i) {
            byte chunkType = ReadWriteIOUtils.readByte((InputStream)stream);
            chunkHeaderList.add(ChunkHeader.deserializeFrom((InputStream)stream, (byte)chunkType));
        }
        ArrayList<Integer> pageNumbers = new ArrayList<Integer>();
        if (needDecodeChunk) {
            for (int i = 0; i < chunkHeaderListSize; ++i) {
                pageNumbers.add(ReadWriteIOUtils.readInt((InputStream)stream));
            }
        }
        AlignedChunkData chunkData = new AlignedChunkData(device, (ChunkHeader)chunkHeaderList.get(0), timePartitionSlot);
        chunkData.needDecodeChunk = needDecodeChunk;
        chunkData.chunkHeaderList = chunkHeaderList;
        chunkData.pageNumbers = pageNumbers;
        chunkData.deserializeTsFileData(stream);
        chunkData.close();
        return chunkData;
    }

    private void close() throws IOException {
        this.byteStream.close();
        this.stream.close();
    }

    public String toString() {
        return "AlignedChunkData{timePartitionSlot=" + this.timePartitionSlot + ", device='" + this.device + '\'' + ", chunkHeaderList=" + this.chunkHeaderList + ", totalDataSize=" + this.dataSize + ", needDecodeChunk=" + this.needDecodeChunk + '}';
    }
}

