/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.udf.api.customizer.parameter;

import java.util.List;
import java.util.Map;
import org.apache.iotdb.udf.api.type.Type;

public class UDFParameters {
    private final List<String> childExpressions;
    private final List<Type> childExpressionDataTypes;
    private final Map<String, String> attributes;

    public UDFParameters(List<String> childExpressions, List<Type> childExpressionDataTypes, Map<String, String> attributes) {
        this.childExpressions = childExpressions;
        this.childExpressionDataTypes = childExpressionDataTypes;
        this.attributes = attributes;
    }

    public List<String> getChildExpressions() {
        return this.childExpressions;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public List<Type> getDataTypes() {
        return this.childExpressionDataTypes;
    }

    public int getChildExpressionsSize() {
        return this.childExpressions.size();
    }

    public Type getDataType(int index) {
        return this.childExpressionDataTypes.get(index);
    }

    public boolean hasAttribute(String attributeKey) {
        return this.attributes.containsKey(attributeKey);
    }

    public String getString(String key) {
        return this.attributes.get(key);
    }

    public Boolean getBoolean(String key) {
        String value = this.attributes.get(key);
        return value == null ? null : Boolean.valueOf(Boolean.parseBoolean(value));
    }

    public Integer getInt(String key) {
        String value = this.attributes.get(key);
        return value == null ? null : Integer.valueOf(Integer.parseInt(value));
    }

    public Long getLong(String key) {
        String value = this.attributes.get(key);
        return value == null ? null : Long.valueOf(Long.parseLong(value));
    }

    public Float getFloat(String key) {
        String value = this.attributes.get(key);
        return value == null ? null : Float.valueOf(Float.parseFloat(value));
    }

    public Double getDouble(String key) {
        String value = this.attributes.get(key);
        return value == null ? null : Double.valueOf(Double.parseDouble(value));
    }

    public String getStringOrDefault(String key, String defaultValue) {
        String value = this.attributes.get(key);
        return value == null ? defaultValue : value;
    }

    public boolean getBooleanOrDefault(String key, boolean defaultValue) {
        String value = this.attributes.get(key);
        return value == null ? defaultValue : Boolean.parseBoolean(value);
    }

    public int getIntOrDefault(String key, int defaultValue) {
        String value = this.attributes.get(key);
        return value == null ? defaultValue : Integer.parseInt(value);
    }

    public long getLongOrDefault(String key, long defaultValue) {
        String value = this.attributes.get(key);
        return value == null ? defaultValue : Long.parseLong(value);
    }

    public float getFloatOrDefault(String key, float defaultValue) {
        String value = this.attributes.get(key);
        return value == null ? defaultValue : Float.parseFloat(value);
    }

    public double getDoubleOrDefault(String key, double defaultValue) {
        String value = this.attributes.get(key);
        return value == null ? defaultValue : Double.parseDouble(value);
    }
}

