/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.node;

import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.impl.statemachine.StateMachineProcedure;
import org.apache.iotdb.confignode.procedure.state.ProcedureLockState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNodeProcedure<TState>
extends StateMachineProcedure<ConfigNodeProcedureEnv, TState> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractNodeProcedure.class);

    @Override
    protected ProcedureLockState acquireLock(ConfigNodeProcedureEnv configNodeProcedureEnv) {
        configNodeProcedureEnv.getSchedulerLock().lock();
        try {
            if (configNodeProcedureEnv.getNodeLock().tryLock(this)) {
                LOG.info("procedureId {} acquire lock.", (Object)this.getProcId());
                ProcedureLockState procedureLockState = ProcedureLockState.LOCK_ACQUIRED;
                return procedureLockState;
            }
            configNodeProcedureEnv.getNodeLock().waitProcedure(this);
            LOG.info("procedureId {} wait for lock.", (Object)this.getProcId());
            ProcedureLockState procedureLockState = ProcedureLockState.LOCK_EVENT_WAIT;
            return procedureLockState;
        }
        finally {
            configNodeProcedureEnv.getSchedulerLock().unlock();
        }
    }

    @Override
    protected void releaseLock(ConfigNodeProcedureEnv configNodeProcedureEnv) {
        configNodeProcedureEnv.getSchedulerLock().lock();
        try {
            LOG.info("procedureId {} release lock.", (Object)this.getProcId());
            if (configNodeProcedureEnv.getNodeLock().releaseLock(this)) {
                configNodeProcedureEnv.getNodeLock().wakeWaitingProcedures(configNodeProcedureEnv.getScheduler());
            }
        }
        finally {
            configNodeProcedureEnv.getSchedulerLock().unlock();
        }
    }
}

