/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.persistence.schema;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.io.IOUtils;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.db.exception.metadata.template.UndefinedTemplateException;
import org.apache.iotdb.db.metadata.template.Template;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateTable {
    private static final Logger LOGGER = LoggerFactory.getLogger(TemplateTable.class);
    private final ReentrantReadWriteLock templateReadWriteLock;
    private final AtomicInteger templateIdGenerator;
    private final Map<String, Template> templateMap = new ConcurrentHashMap<String, Template>();
    private final Map<Integer, Template> templateIdMap = new ConcurrentHashMap<Integer, Template>();
    private static final String SNAPSHOT_FILENAME = "template_info.bin";

    public TemplateTable() {
        this.templateReadWriteLock = new ReentrantReadWriteLock();
        this.templateIdGenerator = new AtomicInteger(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Template getTemplate(String name) throws MetadataException {
        try {
            this.templateReadWriteLock.readLock().lock();
            Template template = this.templateMap.get(name);
            if (template == null) {
                throw new MetadataException(String.format("Template %s does not exist", name));
            }
            Template template2 = this.templateMap.get(name);
            return template2;
        }
        finally {
            this.templateReadWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Template getTemplate(int templateId) throws MetadataException {
        try {
            this.templateReadWriteLock.readLock().lock();
            Template template = this.templateIdMap.get(templateId);
            if (template == null) {
                throw new MetadataException(String.format("Template with id=%s does not exist", templateId));
            }
            Template template2 = template;
            return template2;
        }
        finally {
            this.templateReadWriteLock.readLock().unlock();
        }
    }

    public List<Template> getAllTemplate() {
        try {
            this.templateReadWriteLock.readLock().lock();
            ArrayList<Template> arrayList = new ArrayList<Template>(this.templateMap.values());
            return arrayList;
        }
        finally {
            this.templateReadWriteLock.readLock().unlock();
        }
    }

    public void createTemplate(Template template) throws MetadataException {
        try {
            this.templateReadWriteLock.writeLock().lock();
            Template temp = this.templateMap.get(template.getName());
            if (temp != null) {
                LOGGER.error("Failed to create template, because template name {} is exists", (Object)template.getName());
                throw new MetadataException("Duplicated template name: " + temp.getName());
            }
            template.setId(this.templateIdGenerator.getAndIncrement());
            this.templateMap.put(template.getName(), template);
            this.templateIdMap.put(template.getId(), template);
        }
        finally {
            this.templateReadWriteLock.writeLock().unlock();
        }
    }

    public void dropTemplate(String templateName) throws MetadataException {
        try {
            this.templateReadWriteLock.writeLock().lock();
            Template temp = this.templateMap.remove(templateName);
            if (temp == null) {
                LOGGER.error("Undefined template {}", (Object)templateName);
                throw new UndefinedTemplateException(templateName);
            }
            this.templateIdMap.remove(temp.getId());
        }
        finally {
            this.templateReadWriteLock.writeLock().unlock();
        }
    }

    private void serialize(OutputStream outputStream) throws IOException {
        ReadWriteIOUtils.write((int)this.templateIdGenerator.get(), (OutputStream)outputStream);
        ReadWriteIOUtils.write((int)this.templateMap.size(), (OutputStream)outputStream);
        for (Map.Entry<String, Template> entry : this.templateMap.entrySet()) {
            this.serializeTemplate(entry.getValue(), outputStream);
        }
    }

    private void serializeTemplate(Template template, OutputStream outputStream) {
        try {
            template.serialize(outputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void deserialize(InputStream inputStream) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.wrap(IOUtils.toByteArray((InputStream)inputStream));
        this.templateIdGenerator.set(ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer));
        for (int size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer); size > 0; --size) {
            Template template = this.deserializeTemplate(byteBuffer);
            this.templateMap.put(template.getName(), template);
            this.templateIdMap.put(template.getId(), template);
        }
    }

    private Template deserializeTemplate(ByteBuffer byteBuffer) {
        Template template = new Template();
        template.deserialize(byteBuffer);
        return template;
    }

    /*
     * Exception decompiling
     */
    public boolean processTakeSnapshot(File snapshotDir) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processLoadSnapshot(File snapshotDir) throws IOException {
        File snapshotFile = new File(snapshotDir, SNAPSHOT_FILENAME);
        if (!snapshotFile.exists() || !snapshotFile.isFile()) {
            LOGGER.error("Failed to load snapshot,snapshot file [{}] is not exist.", (Object)snapshotFile.getAbsolutePath());
            return;
        }
        this.templateReadWriteLock.writeLock().lock();
        try (FileInputStream fileInputStream = new FileInputStream(snapshotFile);
             BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);){
            this.templateMap.clear();
            this.deserialize(bufferedInputStream);
            bufferedInputStream.close();
            fileInputStream.close();
        }
        finally {
            this.templateReadWriteLock.writeLock().unlock();
        }
    }

    public void clear() {
        this.templateMap.clear();
    }
}

