/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.write.database;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.commons.utils.ThriftConfigNodeSerDeUtils;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;
import org.apache.iotdb.confignode.rpc.thrift.TDatabaseSchema;

public class DatabaseSchemaPlan
extends ConfigPhysicalPlan {
    private TDatabaseSchema schema = new TDatabaseSchema();

    public DatabaseSchemaPlan(ConfigPhysicalPlanType planType) {
        super(planType);
    }

    public DatabaseSchemaPlan(ConfigPhysicalPlanType planType, TDatabaseSchema schema) {
        this(planType);
        this.schema = schema;
    }

    public TDatabaseSchema getSchema() {
        return this.schema;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        stream.writeShort(this.getType().getPlanType());
        ThriftConfigNodeSerDeUtils.serializeTStorageGroupSchema((TDatabaseSchema)this.schema, (OutputStream)stream);
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) throws IOException {
        this.schema = ThriftConfigNodeSerDeUtils.deserializeTStorageGroupSchema((ByteBuffer)buffer);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DatabaseSchemaPlan that = (DatabaseSchemaPlan)o;
        return this.schema.equals(that.schema);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.schema);
    }
}

