/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.client.async.handlers.rpc;

import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.confignode.client.DataNodeRequestType;
import org.apache.iotdb.confignode.client.async.handlers.rpc.AsyncTSStatusRPCHandler;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperatePipeRPCHandler
extends AsyncTSStatusRPCHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(OperatePipeRPCHandler.class);

    public OperatePipeRPCHandler(DataNodeRequestType requestType, int requestId, TDataNodeLocation targetDataNode, Map<Integer, TDataNodeLocation> dataNodeLocationMap, Map<Integer, TSStatus> responseMap, CountDownLatch countDownLatch) {
        super(requestType, requestId, targetDataNode, dataNodeLocationMap, responseMap, countDownLatch);
    }

    @Override
    public void onError(Exception e) {
        String errorMsg = e.getMessage() + " on DataNode: " + this.formattedTargetLocation;
        LOGGER.error(errorMsg);
        this.responseMap.put(this.requestId, new TSStatus(RpcUtils.getStatus((int)TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode(), (String)errorMsg)));
        this.countDownLatch.countDown();
    }
}

