/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.ratis.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RatisLogMonitor {
    private static final Logger logger = LoggerFactory.getLogger(RatisLogMonitor.class);
    private static final Predicate<Path> isOpenSegment = p -> p.toFile().getName().startsWith("log_inprogress");
    private final HashMap<File, DirectoryState> directoryMap = new HashMap();

    public long updateAndGetDirectorySize(File dir) {
        Set<Path> latest;
        DirectoryState state = this.directoryMap.computeIfAbsent(dir, d -> new DirectoryState());
        try (Stream<Path> files = Files.list(dir.toPath());){
            latest = files.filter(isOpenSegment).collect(Collectors.toSet());
        }
        catch (IOException e) {
            logger.warn("{}: Error caught when listing files under {}:", new Object[]{this, dir, e});
            return state.size;
        }
        long sizeDiff = RatisLogMonitor.diff(state.memorizedFiles, latest);
        long newSize = state.size + sizeDiff;
        state.update(newSize, latest);
        return newSize;
    }

    public Set<Path> getFilesUnder(File dir) {
        return Collections.unmodifiableSet(this.directoryMap.get(dir).memorizedFiles);
    }

    private static long diff(Set<Path> old, Set<Path> latest) {
        long incremental = RatisLogMonitor.totalSize(latest.stream().filter(p -> !old.contains(p)));
        long decremental = RatisLogMonitor.totalSize(old.stream().filter(p -> !latest.contains(p)));
        return incremental - decremental;
    }

    private static long totalSize(Stream<Path> files) {
        return files.mapToLong(p -> p.toFile().length()).sum();
    }

    private static final class DirectoryState {
        private long size = 0L;
        private Set<Path> memorizedFiles = Collections.emptySet();

        private DirectoryState() {
        }

        private void update(long size, Set<Path> latest) {
            this.size = size;
            this.memorizedFiles = latest;
        }
    }
}

