/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.statement.component;

import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.mpp.plan.statement.StatementNode;
import org.apache.iotdb.db.mpp.plan.statement.component.ResultColumn;

public class SelectComponent
extends StatementNode {
    private final ZoneId zoneId;
    private boolean hasLast = false;
    private boolean hasBuiltInAggregationFunction = false;
    protected List<ResultColumn> resultColumns = new ArrayList<ResultColumn>();
    private Map<String, Expression> aliasToColumnMap;

    public SelectComponent(ZoneId zoneId) {
        this.zoneId = zoneId;
    }

    public ZoneId getZoneId() {
        return this.zoneId;
    }

    public boolean isHasBuiltInAggregationFunction() {
        return this.hasBuiltInAggregationFunction;
    }

    public void addResultColumn(ResultColumn resultColumn) {
        this.resultColumns.add(resultColumn);
        ResultColumn.ColumnType columnType = resultColumn.getColumnType();
        if (columnType == ResultColumn.ColumnType.AGGREGATION) {
            this.hasBuiltInAggregationFunction = true;
        }
    }

    public void setResultColumns(List<ResultColumn> resultColumns) {
        this.resultColumns = resultColumns;
    }

    public List<ResultColumn> getResultColumns() {
        return this.resultColumns;
    }

    public Map<String, Expression> getAliasToColumnMap() {
        return this.aliasToColumnMap;
    }

    public void setAliasToColumnMap(Map<String, Expression> aliasToColumnMap) {
        this.aliasToColumnMap = aliasToColumnMap;
    }

    public boolean hasLast() {
        return this.hasLast;
    }

    public void setHasLast(boolean hasLast) {
        this.hasLast = hasLast;
    }

    public void setHasBuiltInAggregationFunction(boolean hasBuiltInAggregationFunction) {
        this.hasBuiltInAggregationFunction = hasBuiltInAggregationFunction;
    }

    public String toSQLString() {
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("SELECT").append(' ');
        if (this.hasLast()) {
            sqlBuilder.append("LAST").append(' ');
        }
        for (int i = 0; i < this.resultColumns.size(); ++i) {
            ResultColumn resultColumn = this.resultColumns.get(i);
            sqlBuilder.append(resultColumn.getExpression().toString());
            if (resultColumn.hasAlias()) {
                sqlBuilder.append('(').append(resultColumn.getAlias()).append(')');
            }
            if (i >= this.resultColumns.size() - 1) continue;
            sqlBuilder.append(", ");
        }
        return sqlBuilder.toString();
    }
}

