/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.schema.source;

import java.util.List;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.metadata.MetadataConstant;
import org.apache.iotdb.db.metadata.plan.schemaregion.impl.read.SchemaRegionReadPlanFactory;
import org.apache.iotdb.db.metadata.query.info.IDeviceSchemaInfo;
import org.apache.iotdb.db.metadata.query.reader.ISchemaReader;
import org.apache.iotdb.db.metadata.schemaregion.ISchemaRegion;
import org.apache.iotdb.db.mpp.common.header.ColumnHeader;
import org.apache.iotdb.db.mpp.common.header.ColumnHeaderConstant;
import org.apache.iotdb.db.mpp.execution.operator.schema.source.ISchemaSource;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.utils.Binary;

public class DeviceSchemaSource
implements ISchemaSource<IDeviceSchemaInfo> {
    private final PartialPath pathPattern;
    private final boolean isPrefixMatch;
    private final long limit;
    private final long offset;
    private final boolean hasSgCol;

    DeviceSchemaSource(PartialPath pathPattern, boolean isPrefixPath, long limit, long offset, boolean hasSgCol) {
        this.pathPattern = pathPattern;
        this.isPrefixMatch = isPrefixPath;
        this.limit = limit;
        this.offset = offset;
        this.hasSgCol = hasSgCol;
    }

    @Override
    public ISchemaReader<IDeviceSchemaInfo> getSchemaReader(ISchemaRegion schemaRegion) {
        try {
            return schemaRegion.getDeviceReader(SchemaRegionReadPlanFactory.getShowDevicesPlan(this.pathPattern, this.limit, this.offset, this.isPrefixMatch));
        }
        catch (MetadataException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public List<ColumnHeader> getInfoQueryColumnHeaders() {
        return this.hasSgCol ? ColumnHeaderConstant.showDevicesWithSgColumnHeaders : ColumnHeaderConstant.showDevicesColumnHeaders;
    }

    @Override
    public void transformToTsBlockColumns(IDeviceSchemaInfo device, TsBlockBuilder builder, String database) {
        builder.getTimeColumnBuilder().writeLong(0L);
        builder.getColumnBuilder(0).writeBinary(new Binary(device.getFullPath()));
        if (this.hasSgCol) {
            builder.getColumnBuilder(1).writeBinary(new Binary(database));
            builder.getColumnBuilder(2).writeBinary(new Binary(String.valueOf(device.isAligned())));
        } else {
            builder.getColumnBuilder(1).writeBinary(new Binary(String.valueOf(device.isAligned())));
        }
        builder.declarePosition();
    }

    @Override
    public boolean hasSchemaStatistic(ISchemaRegion schemaRegion) {
        return this.pathPattern.equals((Object)MetadataConstant.ALL_MATCH_PATTERN);
    }

    @Override
    public long getSchemaStatistic(ISchemaRegion schemaRegion) {
        return schemaRegion.getSchemaRegionStatistics().getDevicesNumber();
    }
}

