/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator;

import io.airlift.units.Duration;
import java.util.Objects;
import org.apache.iotdb.db.mpp.common.SessionInfo;
import org.apache.iotdb.db.mpp.execution.driver.DriverContext;
import org.apache.iotdb.db.mpp.execution.fragment.FragmentInstanceContext;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;

public class OperatorContext {
    private final int operatorId;
    private final PlanNodeId planNodeId;
    private final String operatorType;
    private DriverContext driverContext;
    private Duration maxRunTime;
    private long totalExecutionTimeInNanos = 0L;
    private long nextCalledCount = 0L;

    public OperatorContext(int operatorId, PlanNodeId planNodeId, String operatorType, DriverContext driverContext) {
        this.operatorId = operatorId;
        this.planNodeId = planNodeId;
        this.operatorType = operatorType;
        this.driverContext = driverContext;
    }

    public OperatorContext(int operatorId, PlanNodeId planNodeId, String operatorType, FragmentInstanceContext fragmentInstanceContext) {
        this.operatorId = operatorId;
        this.planNodeId = planNodeId;
        this.operatorType = operatorType;
        this.driverContext = new DriverContext(fragmentInstanceContext, 0);
    }

    public int getOperatorId() {
        return this.operatorId;
    }

    public String getOperatorType() {
        return this.operatorType;
    }

    public DriverContext getDriverContext() {
        return this.driverContext;
    }

    public void setDriverContext(DriverContext driverContext) {
        this.driverContext = driverContext;
    }

    public FragmentInstanceContext getInstanceContext() {
        return this.driverContext.getFragmentInstanceContext();
    }

    public Duration getMaxRunTime() {
        return this.maxRunTime;
    }

    public void setMaxRunTime(Duration maxRunTime) {
        this.maxRunTime = maxRunTime;
    }

    public SessionInfo getSessionInfo() {
        return this.getInstanceContext().getSessionInfo();
    }

    public void recordExecutionTime(long executionTimeInNanos) {
        this.totalExecutionTimeInNanos += executionTimeInNanos;
    }

    public void recordNextCalled() {
        ++this.nextCalledCount;
    }

    public long getTotalExecutionTimeInNanos() {
        return this.totalExecutionTimeInNanos;
    }

    public long getNextCalledCount() {
        return this.nextCalledCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperatorContext that = (OperatorContext)o;
        return this.operatorId == that.operatorId;
    }

    public int hashCode() {
        return Objects.hash(this.operatorId);
    }
}

